/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.azureaaron.dandelion.moulconfig.MoulConfigAdapter;
import net.azureaaron.dandelion.platform.ConfigType;
import net.azureaaron.dandelion.systems.ConfigCategory;
import net.azureaaron.dandelion.systems.ConfigManager;
import net.azureaaron.dandelion.systems.DandelionConfigScreen;
import net.azureaaron.dandelion.yacl.YACLScreenAdapter;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.apache.commons.lang3.function.TriFunction;

public class DandelionConfigScreenImpl<T>
implements DandelionConfigScreen {
    private final ConfigManager<T> manager;
    private final class_2561 title;
    private final List<ConfigCategory> categories;

    public DandelionConfigScreenImpl(ConfigManager<T> manager, TriFunction<T, T, DandelionConfigScreen.Builder, DandelionConfigScreen.Builder> screenBuilder) {
        this.manager = Objects.requireNonNull(manager, "manager must not be null");
        Objects.requireNonNull(screenBuilder, "screenBuilder must not be null");
        DandelionConfigScreenBuilderImpl builder = new DandelionConfigScreenBuilderImpl();
        screenBuilder.apply(manager.defaults(), manager.instance(), (Object)builder);
        this.title = builder.title;
        this.categories = builder.categories;
    }

    @Override
    public class_437 generateScreen(class_437 parent, ConfigType configType) {
        Objects.requireNonNull(configType, "configType must not be null");
        return switch (configType) {
            default -> throw new MatchException(null, null);
            case ConfigType.YACL -> YACLScreenAdapter.generateYaclScreen(this.manager, this.title, this.categories, parent);
            case ConfigType.MOUL_CONFIG -> new MoulConfigAdapter(this.manager, this.title).generateMoulConfigScreen(this.categories, parent);
        };
    }

    protected static class DandelionConfigScreenBuilderImpl
    implements DandelionConfigScreen.Builder {
        private class_2561 title = class_2561.method_43473();
        private List<ConfigCategory> categories = new ArrayList<ConfigCategory>();

        protected DandelionConfigScreenBuilderImpl() {
        }

        @Override
        public DandelionConfigScreen.Builder title(class_2561 title) {
            this.title = title;
            return this;
        }

        @Override
        public DandelionConfigScreen.Builder category(ConfigCategory category) {
            this.categories.add(category);
            return this;
        }
    }
}

