/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.impl;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.azureaaron.dandelion.impl.ConfigManagerImpl;
import net.azureaaron.dandelion.impl.utils.CodecTypeAdapter;
import net.azureaaron.dandelion.impl.utils.CodecUtils;
import net.azureaaron.dandelion.impl.utils.ItemTypeAdapter;
import net.azureaaron.dandelion.impl.utils.StyleTypeAdapter;
import net.azureaaron.dandelion.systems.ConfigSerializer;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_8824;
import org.slf4j.Logger;

public class GsonConfigSerializer<T>
extends ConfigSerializer<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Gson gson;

    protected GsonConfigSerializer(ConfigManagerImpl<T> configManager, Path path, Gson gson) {
        super(configManager, path);
        this.gson = Objects.requireNonNull(gson, "gson must not be null");
    }

    @Override
    public boolean save() {
        Object instance = this.configManager.instance();
        if (instance == null) {
            LOGGER.warn("[Dandelion] Cannot save a null instance of {} to {}! Skipping save.", this.configManager.configClass(), (Object)this.path);
            return false;
        }
        try {
            String json = this.gson.toJson(instance, this.configManager.configClass());
            Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
            Files.writeString(this.path, (CharSequence)json, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            LOGGER.info("[Dandelion] Successfully saved {} to {}.", this.configManager.configClass(), (Object)this.path);
            return true;
        }
        catch (Exception e) {
            LOGGER.error(LogUtils.FATAL_MARKER, "[Dandelion] Failed to save {} to {}!", new Object[]{this.configManager.configClass(), this.path, e});
            return false;
        }
    }

    @Override
    public boolean load() {
        if (!Files.exists(this.path, new LinkOption[0])) {
            LOGGER.info("[Dandelion] No config found for {} at {}. Initializing and saving default config.", this.configManager.configClass(), (Object)this.path);
            this.configManager.setInstance(this.configManager.createNewConfigInstance());
            this.save();
            return true;
        }
        try {
            String config = Files.readString(this.path);
            Object instance = this.gson.fromJson(JsonParser.parseString((String)config), this.configManager.configClass());
            this.configManager.setInstance(instance);
            LOGGER.info("[Dandelion] Successfully loaded {} from {}.", this.configManager.configClass(), (Object)this.path);
            return true;
        }
        catch (Exception e) {
            LOGGER.error(LogUtils.FATAL_MARKER, "[Dandelion] Failed to load the {} from {}!", new Object[]{this.configManager.configClass(), this.path, e});
            return false;
        }
    }

    protected static GsonBuilder createDefaultGsonBuilder() {
        return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).serializeNulls().registerTypeHierarchyAdapter(Color.class, new CodecTypeAdapter<Color>(CodecUtils.COLOUR_CODEC)).registerTypeHierarchyAdapter(class_2561.class, new CodecTypeAdapter(class_8824.field_46597)).registerTypeHierarchyAdapter(class_2583.class, (Object)new StyleTypeAdapter()).registerTypeHierarchyAdapter(class_2960.class, new CodecTypeAdapter(class_2960.field_25139)).registerTypeHierarchyAdapter(class_1792.class, (Object)new ItemTypeAdapter()).setPrettyPrinting();
    }
}

