/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.azureaaron.dandelion.impl.OptionBindingImpl;
import net.azureaaron.dandelion.impl.OptionImpl;
import net.azureaaron.dandelion.impl.utils.ReflectionUtils;
import net.azureaaron.dandelion.systems.ListOption;
import net.azureaaron.dandelion.systems.Option;
import net.azureaaron.dandelion.systems.OptionBinding;
import net.azureaaron.dandelion.systems.OptionFlag;
import net.azureaaron.dandelion.systems.OptionListener;
import net.azureaaron.dandelion.systems.controllers.Controller;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ListOptionImpl<T>
implements ListOption<T> {
    @Nullable
    private final class_2960 id;
    private final class_2561 name;
    private final List<class_2561> description;
    private final List<class_2561> tags;
    private final OptionBinding<List<T>> binding;
    private final Controller<T> controller;
    private final Supplier<T> initialValue;
    private final boolean collapsed;
    private final boolean modifiable;
    private final List<OptionFlag> flags;
    private final List<OptionListener<List<T>>> listeners;
    private final Class<List<T>> type;
    private final Class<T> entryType;
    private final List<Option<T>> entries;

    public ListOptionImpl(@Nullable class_2960 id, class_2561 name, List<class_2561> description, List<class_2561> tags, OptionBinding<List<T>> binding, Controller<T> controller, Supplier<T> initialValue, boolean collapsed, boolean modifiable, List<OptionFlag> flags, List<OptionListener<List<T>>> listeners) {
        this.id = id;
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.description = Objects.requireNonNull(description, "description must not be null");
        this.tags = Objects.requireNonNull(tags, "tags must not be null");
        this.binding = Objects.requireNonNull(binding, "binding must not be null");
        this.controller = Objects.requireNonNull(controller, "controller must not be null");
        this.initialValue = initialValue;
        this.collapsed = collapsed;
        this.modifiable = modifiable;
        this.flags = Objects.requireNonNull(flags, "flags must not be null");
        this.listeners = Objects.requireNonNull(listeners, "listeners must not be null");
        this.type = ReflectionUtils.getActualClass(Objects.requireNonNull(this.binding().defaultValue(), "the default value of an list option must not be null"));
        this.entryType = ReflectionUtils.getActualClass(Objects.requireNonNull(this.initialValue.get(), "the initial value of an entry in an list option must not be null"));
        this.entries = this.createEntries(this.binding().get());
    }

    @Override
    @Nullable
    public class_2960 id() {
        return this.id;
    }

    @Override
    public class_2561 name() {
        return this.name;
    }

    @Override
    public List<class_2561> description() {
        return this.description;
    }

    @Override
    public List<class_2561> tags() {
        return this.tags;
    }

    @Override
    public OptionBinding<List<T>> binding() {
        return this.binding;
    }

    @Override
    public Controller<List<T>> controller() {
        throw new UnsupportedOperationException("list options do not have a controller, see entryController() instead");
    }

    @Override
    public Controller<T> entryController() {
        return this.controller;
    }

    @Override
    public Supplier<T> initialValue() {
        return this.initialValue;
    }

    @Override
    public boolean collapsed() {
        return this.collapsed;
    }

    @Override
    public boolean modifiable() {
        return this.modifiable;
    }

    @Override
    public List<OptionFlag> flags() {
        return this.flags;
    }

    @Override
    public List<OptionListener<List<T>>> listeners() {
        return this.listeners;
    }

    @Override
    public Class<List<T>> type() {
        return this.type;
    }

    @Override
    public Class<T> entryType() {
        return this.entryType;
    }

    public List<Option<T>> options() {
        return this.entries;
    }

    private List<Option<T>> createEntries(List<T> values) {
        ArrayList<Option<T>> entries = new ArrayList<Option<T>>();
        for (int i2 = 0; i2 < values.size(); ++i2) {
            entries.add(this.createEntry(values, i2));
        }
        return entries;
    }

    private Option<T> createEntry(List<T> values, int i2) {
        return new OptionImpl<Object>(this.id, this.name(), this.description(), this.tags(), new OptionBindingImpl<Object>(this.initialValue().get(), () -> values.get(i2), newValue -> values.set(i2, newValue)), this.entryController(), this.modifiable(), this.flags(), List.of((entryOption, updateType) -> this.listeners().forEach(l -> l.onUpdate(this, updateType))));
    }

    public static class BuilderImpl<T>
    implements ListOption.Builder<T> {
        private class_2960 id = null;
        private class_2561 name = class_2561.method_43473();
        private List<class_2561> description = List.of();
        private List<class_2561> tags = List.of();
        private OptionBinding<List<T>> binding = null;
        private Controller<T> controller = null;
        private Supplier<T> initialValue = null;
        private boolean collapsed = false;
        private boolean modifiable = true;
        private List<OptionFlag> flags = List.of();
        private final List<OptionListener<List<T>>> listeners = new ArrayList<OptionListener<List<T>>>();

        @Override
        public ListOption.Builder<T> id(class_2960 id) {
            this.id = id;
            return this;
        }

        @Override
        public ListOption.Builder<T> name(class_2561 name) {
            this.name = name;
            return this;
        }

        @Override
        public ListOption.Builder<T> description(class_2561 ... texts) {
            this.description = List.of(texts);
            return this;
        }

        @Override
        public ListOption.Builder<T> tags(class_2561 ... tags) {
            this.tags = List.of(tags);
            return this;
        }

        @Override
        public ListOption.Builder<T> binding(List<T> defaultValue, Supplier<List<T>> getter, Consumer<List<T>> setter) {
            this.binding = new OptionBindingImpl<List<List<T>>>(defaultValue, getter, setter);
            return this;
        }

        @Override
        public ListOption.Builder<T> controller(Controller<T> controller) {
            this.controller = controller;
            return this;
        }

        @Override
        public ListOption.Builder<T> initial(Supplier<T> initialValue) {
            this.initialValue = initialValue;
            return this;
        }

        @Override
        public ListOption.Builder<T> initial(T initialValue) {
            this.initialValue = () -> initialValue;
            return this;
        }

        @Override
        public ListOption.Builder<T> collapsed(boolean collapsed) {
            this.collapsed = collapsed;
            return this;
        }

        @Override
        public ListOption.Builder<T> modifiable(boolean modifiable) {
            this.modifiable = modifiable;
            return this;
        }

        @Override
        public ListOption.Builder<T> flags(OptionFlag ... flags) {
            this.flags = List.of(flags);
            return this;
        }

        @Override
        public ListOption.Builder<T> listener(OptionListener<List<T>> listener) {
            this.listeners.add(listener);
            return this;
        }

        @Override
        public ListOption<T> build() {
            return new ListOptionImpl<T>(this.id, this.name, this.description, this.tags, this.binding, this.controller, this.initialValue, this.collapsed, this.modifiable, this.flags, List.copyOf(this.listeners));
        }
    }
}

