/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.moulconfig;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.azureaaron.dandelion.deps.moulconfig.common.text.StructuredText;
import net.azureaaron.dandelion.deps.moulconfig.gui.editors.GuiOptionEditorAccordion;
import net.azureaaron.dandelion.deps.moulconfig.platform.MoulConfigPlatform;
import net.azureaaron.dandelion.deps.moulconfig.processor.ProcessedCategory;
import net.azureaaron.dandelion.deps.moulconfig.processor.ProcessedOption;
import net.azureaaron.dandelion.moulconfig.DandelionProcessedOption;
import net.azureaaron.dandelion.systems.ConfigCategory;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class DandelionProcessedCategory
implements ProcessedCategory {
    private final ConfigCategory category;
    private final List<DandelionProcessedOption> options;
    private final Map<Integer, DandelionProcessedOption> accordions;

    protected DandelionProcessedCategory(ConfigCategory category, List<DandelionProcessedOption> options) {
        this.category = category;
        this.options = List.copyOf(options);
        this.accordions = this.options.stream().filter(opt -> opt.editor instanceof GuiOptionEditorAccordion).collect(Collectors.toUnmodifiableMap(opt -> ((GuiOptionEditorAccordion)opt.editor).getAccordionId(), Function.identity()));
        for (DandelionProcessedOption option : this.options) {
            option.category = this;
        }
    }

    @Override
    @Nullable
    public String getDebugDeclarationLocation() {
        return this.category.id().toString();
    }

    @Override
    public StructuredText getDisplayName() {
        return MoulConfigPlatform.wrap(this.category.name());
    }

    @Override
    public StructuredText getDescription() {
        return MoulConfigPlatform.wrap(this.category.description());
    }

    @Override
    public String getIdentifier() {
        return this.category.id().toString();
    }

    @Override
    @Nullable
    public String getParentCategoryId() {
        return null;
    }

    public @Unmodifiable List<ProcessedOption> getOptions() {
        return (List)List.class.cast(this.options);
    }

    public @Unmodifiable Map<Integer, ProcessedOption> getAccordionAnchors() {
        return (Map)Map.class.cast(this.accordions);
    }
}

