/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.moulconfig;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Type;
import net.azureaaron.dandelion.deps.moulconfig.Config;
import net.azureaaron.dandelion.deps.moulconfig.annotations.SearchTag;
import net.azureaaron.dandelion.deps.moulconfig.common.text.StructuredText;
import net.azureaaron.dandelion.deps.moulconfig.platform.MoulConfigPlatform;
import net.azureaaron.dandelion.moulconfig.DandelionProcessedOption;
import net.azureaaron.dandelion.moulconfig.DandelionSearchTag;
import net.azureaaron.dandelion.systems.Option;
import net.azureaaron.dandelion.systems.OptionListener;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class DandelionProcessedEditableOption<T>
extends DandelionProcessedOption {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final Option<T> option;

    protected DandelionProcessedEditableOption(Option<T> option, int accordionId, Config config) {
        super(accordionId, config);
        this.option = option;
    }

    @Override
    public StructuredText getName() {
        return MoulConfigPlatform.wrap(this.option.name());
    }

    @Override
    public StructuredText getDescription() {
        class_5250 concat = class_2561.method_43473();
        concat.method_10855().addAll(this.option.description());
        return MoulConfigPlatform.wrap((class_2561)concat);
    }

    @Override
    public SearchTag[] getSearchTags() {
        SearchTag[] tags = (SearchTag[])this.option.tags().stream().map(class_2561::getString).map(DandelionSearchTag::new).toArray(DandelionSearchTag[]::new);
        return tags;
    }

    @Override
    public Type getType() {
        return this.option.type();
    }

    @Override
    public Object get() {
        return this.option.binding().get();
    }

    @Override
    public boolean set(Object value) {
        try {
            this.option.binding().set(value);
            this.explicitNotifyChange();
            return true;
        }
        catch (Exception e) {
            LOGGER.error("[Dandelion] Failed to set option! Id: {}, Name: {}", new Object[]{this.option.id(), this.getName(), e});
            return false;
        }
    }

    @Override
    public void explicitNotifyChange() {
        this.option.listeners().forEach(listener -> listener.onUpdate(this.option, OptionListener.UpdateType.VALUE_CHANGE));
    }

    @Override
    @Nullable
    public String getDebugDeclarationLocation() {
        return this.option.id() != null ? this.option.id().toString() : this.getName().getText();
    }
}

