/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.moulconfig;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiContext;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiElementComponent;
import net.azureaaron.dandelion.deps.moulconfig.gui.MoulConfigEditor;
import net.azureaaron.dandelion.deps.moulconfig.platform.MoulConfigScreenComponent;
import net.azureaaron.dandelion.deps.moulconfig.processor.ProcessedCategory;
import net.azureaaron.dandelion.moulconfig.DandelionProcessedCategory;
import net.azureaaron.dandelion.moulconfig.DandelionProcessedEditableOption;
import net.azureaaron.dandelion.moulconfig.DandelionProcessedGroupOption;
import net.azureaaron.dandelion.moulconfig.DandelionProcessedOption;
import net.azureaaron.dandelion.moulconfig.MoulConfigDefinition;
import net.azureaaron.dandelion.moulconfig.MoulConfigEditableOptionAdapter;
import net.azureaaron.dandelion.systems.ConfigCategory;
import net.azureaaron.dandelion.systems.ConfigManager;
import net.azureaaron.dandelion.systems.Option;
import net.azureaaron.dandelion.systems.OptionGroup;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class MoulConfigAdapter {
    private static final int ROOT_ACCORDION = -1;
    private final ConfigManager<?> manager;
    private final class_2561 title;
    private final MoulConfigDefinition configDefinition;
    private final Map<Option<?>, BiFunction<Integer, MoulConfigDefinition, DandelionProcessedEditableOption<?>>> editableOptionFactories = new LinkedHashMap();

    public MoulConfigAdapter(ConfigManager<?> manager, class_2561 title) {
        this.manager = manager;
        this.title = title;
        this.configDefinition = new MoulConfigDefinition(title);
    }

    public class_437 generateMoulConfigScreen(List<ConfigCategory> categories, class_437 parent) {
        this.generateEditableOptions(categories);
        List<DandelionProcessedCategory> processedCategories = this.generateProcessedCategories(categories);
        MoulConfigEditor<MoulConfigDefinition> editor = new MoulConfigEditor<MoulConfigDefinition>(ProcessedCategory.collect(processedCategories), this.configDefinition);
        MoulConfigScreenComponent moulConfigScreenComponent = new MoulConfigScreenComponent(this.title, new GuiContext(new GuiElementComponent(editor)), parent);
        moulConfigScreenComponent.getGuiContext().setCloseRequestHandler(() -> {
            this.manager.save();
            Screens.getClient((class_437)moulConfigScreenComponent).method_1507(moulConfigScreenComponent.getPreviousScreen());
        });
        return moulConfigScreenComponent;
    }

    private void generateEditableOptions(List<ConfigCategory> categories) {
        Stream allRootOptions = categories.stream().map(ConfigCategory::rootGroup).filter(Objects::nonNull).flatMap(group -> group.options().stream());
        Stream allGroupedOptions = categories.stream().flatMap(category -> category.groups().stream()).flatMap(group -> group.options().stream());
        List allOptions = Stream.concat(allRootOptions, allGroupedOptions).toList();
        for (Option option : allOptions) {
            this.editableOptionFactories.put(option, MoulConfigEditableOptionAdapter.createEditableOptionFactory(option));
        }
    }

    private List<DandelionProcessedCategory> generateProcessedCategories(List<ConfigCategory> categories) {
        return categories.stream().map(category -> {
            ArrayList<DandelionProcessedOption> processedOptions = new ArrayList<DandelionProcessedOption>();
            int nextAccordionId = 1717;
            if (category.rootGroup() != null) {
                this.addProcessedOptionsToGroup(processedOptions, category.rootGroup().options(), -1);
            }
            for (OptionGroup group : category.groups()) {
                int groupAccordionId = nextAccordionId++;
                processedOptions.add(new DandelionProcessedGroupOption(group, -1, groupAccordionId, this.configDefinition));
                this.addProcessedOptionsToGroup(processedOptions, group.options(), groupAccordionId);
            }
            return new DandelionProcessedCategory((ConfigCategory)category, (List<DandelionProcessedOption>)processedOptions);
        }).toList();
    }

    private void addProcessedOptionsToGroup(List<DandelionProcessedOption> processedOptions, List<? extends Option<?>> options, int groupAccordionId) {
        for (Option<?> option : options) {
            DandelionProcessedEditableOption<?> processedOption = this.editableOptionFactories.get(option).apply(groupAccordionId, this.configDefinition);
            processedOptions.add(processedOption);
        }
    }
}

