/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.dandelion.moulconfig;

import java.awt.Color;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.azureaaron.dandelion.deps.moulconfig.Config;
import net.azureaaron.dandelion.deps.moulconfig.gui.GuiOptionEditor;
import net.azureaaron.dandelion.deps.moulconfig.gui.editors.GuiOptionEditorBoolean;
import net.azureaaron.dandelion.deps.moulconfig.gui.editors.GuiOptionEditorButton;
import net.azureaaron.dandelion.deps.moulconfig.gui.editors.GuiOptionEditorDropdown;
import net.azureaaron.dandelion.deps.moulconfig.gui.editors.GuiOptionEditorText;
import net.azureaaron.dandelion.deps.moulconfig.platform.MoulConfigPlatform;
import net.azureaaron.dandelion.mixins.GuiOptionEditorDropdownAccessor;
import net.azureaaron.dandelion.moulconfig.DandelionProcessedEditableOption;
import net.azureaaron.dandelion.moulconfig.MoulConfigDefinition;
import net.azureaaron.dandelion.moulconfig.editor.DandelionColourEditor;
import net.azureaaron.dandelion.moulconfig.editor.DandelionItemEditor;
import net.azureaaron.dandelion.moulconfig.editor.DandelionLabelEditor;
import net.azureaaron.dandelion.moulconfig.editor.DandelionNumberFieldEditor;
import net.azureaaron.dandelion.moulconfig.editor.DandelionNumberSliderEditor;
import net.azureaaron.dandelion.systems.ButtonOption;
import net.azureaaron.dandelion.systems.LabelOption;
import net.azureaaron.dandelion.systems.Option;
import net.azureaaron.dandelion.systems.controllers.BooleanController;
import net.azureaaron.dandelion.systems.controllers.ColourController;
import net.azureaaron.dandelion.systems.controllers.Controller;
import net.azureaaron.dandelion.systems.controllers.EnumController;
import net.azureaaron.dandelion.systems.controllers.FloatController;
import net.azureaaron.dandelion.systems.controllers.IntegerController;
import net.azureaaron.dandelion.systems.controllers.ItemController;
import net.azureaaron.dandelion.systems.controllers.StringController;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class MoulConfigEditableOptionAdapter {
    public static <T> BiFunction<Integer, MoulConfigDefinition, DandelionProcessedEditableOption<?>> createEditableOptionFactory(Option<T> option) {
        Option<Boolean> option2 = option;
        Objects.requireNonNull(option2);
        Option<Boolean> option3 = option2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ButtonOption.class, LabelOption.class, Option.class}, option3, n)) {
            case 0 -> {
                ButtonOption button = (ButtonOption)option3;
                yield MoulConfigEditableOptionAdapter.createButtonOption(button);
            }
            case 1 -> {
                LabelOption label = (LabelOption)option3;
                yield MoulConfigEditableOptionAdapter.createLabelOption(label);
            }
            default -> {
                Option<Boolean> _option = option3;
                Controller<T> v2 = option.controller();
                Objects.requireNonNull(v2);
                Controller<T> var15_6 = v2;
                int var16_7 = 0;
                block15: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BooleanController.class, ColourController.class, EnumController.class, FloatController.class, FloatController.class, IntegerController.class, IntegerController.class, ItemController.class, StringController.class}, var15_6, var16_7)) {
                        case 0: {
                            BooleanController booleanController = (BooleanController)var15_6;
                            yield MoulConfigEditableOptionAdapter.createBooleanOption(option);
                        }
                        case 1: {
                            ColourController colourController = (ColourController)var15_6;
                            yield MoulConfigEditableOptionAdapter.createColourOption(option);
                        }
                        case 2: {
                            EnumController enumController = (EnumController)var15_6;
                            yield MoulConfigEditableOptionAdapter.createEnumOption((Option)Option.class.cast(option));
                        }
                        case 3: {
                            FloatController floatController = (FloatController)var15_6;
                            if (floatController.slider()) {
                                var16_7 = 4;
                                continue block15;
                            }
                            yield MoulConfigEditableOptionAdapter.createFloatFieldOption(option);
                        }
                        case 4: {
                            FloatController floatController = (FloatController)var15_6;
                            if (!floatController.slider()) {
                                var16_7 = 5;
                                continue block15;
                            }
                            yield MoulConfigEditableOptionAdapter.createFloatSliderOption(option);
                        }
                        case 5: {
                            IntegerController integerController = (IntegerController)var15_6;
                            if (integerController.slider()) {
                                var16_7 = 6;
                                continue block15;
                            }
                            yield MoulConfigEditableOptionAdapter.createIntegerFieldOption(option);
                        }
                        case 6: {
                            IntegerController integerController = (IntegerController)var15_6;
                            if (!integerController.slider()) {
                                var16_7 = 7;
                                continue block15;
                            }
                            yield MoulConfigEditableOptionAdapter.createIntegerSliderOption(option);
                        }
                        case 7: {
                            ItemController itemController = (ItemController)var15_6;
                            yield MoulConfigEditableOptionAdapter.createItemOption(option);
                        }
                        case 8: {
                            StringController stringController = (StringController)var15_6;
                            yield MoulConfigEditableOptionAdapter.createStringOption(option);
                        }
                    }
                    break;
                }
                throw new UnsupportedOperationException(String.format("The controller %s is not supported by the MoulConfig backend.", option.controller().getClass().getName()));
            }
        };
    }

    private static BiFunction<Integer, MoulConfigDefinition, DandelionProcessedEditableOption<?>> createButtonOption(ButtonOption button) {
        return (accordionId, configDefinition) -> new DandelionProcessedEditableOption<Consumer<class_437>>((Option)button, accordionId.intValue(), (Config)configDefinition){

            @Override
            public Type getType() {
                return Runnable.class;
            }

            @Override
            public Object get() {
                Runnable action = () -> ((ButtonOption)this.option).action().accept(class_310.method_1551().field_1755);
                return action;
            }

            @Override
            protected GuiOptionEditor createEditor() {
                ButtonOption instance = (ButtonOption)this.option;
                return new GuiOptionEditorButton(this, -1, MoulConfigPlatform.wrap(instance.prompt()), this.getConfig());
            }
        };
    }

    private static BiFunction<Integer, MoulConfigDefinition, DandelionProcessedEditableOption<?>> createLabelOption(LabelOption label) {
        return (accordionId, configDefinition) -> new DandelionProcessedEditableOption<class_2561>((Option)label, accordionId.intValue(), (Config)configDefinition){

            @Override
            protected GuiOptionEditor createEditor() {
                return new DandelionLabelEditor(this, MoulConfigPlatform.wrap(((LabelOption)this.option).label()));
            }
        };
    }

    private static BiFunction<Integer, MoulConfigDefinition, DandelionProcessedEditableOption<?>> createBooleanOption(Option<Boolean> option) {
        return (accordionId, configDefinition) -> new DandelionProcessedEditableOption<Boolean>(option, accordionId.intValue(), (Config)configDefinition){

            @Override
            protected GuiOptionEditor createEditor() {
                return new GuiOptionEditorBoolean(this, -1, configDefinition);
            }
        };
    }

    private static BiFunction<Integer, MoulConfigDefinition, DandelionProcessedEditableOption<?>> createColourOption(Option<Color> option) {
        return (accordionId, configDefinition) -> new DandelionProcessedEditableOption<Color>(option, accordionId.intValue(), (Config)configDefinition){

            @Override
            protected GuiOptionEditor createEditor() {
                return new DandelionColourEditor(this, ((ColourController)this.option.controller()).hasAlpha());
            }
        };
    }

    private static <T extends Enum<T>> BiFunction<Integer, MoulConfigDefinition, DandelionProcessedEditableOption<?>> createEnumOption(Option<T> option) {
        return (accordionId, configDefinition) -> new DandelionProcessedEditableOption<T>(option, accordionId.intValue(), (Config)configDefinition){

            @Override
            protected GuiOptionEditor createEditor() {
                Enum[] constants = (Enum[])this.option.type().getEnumConstants();
                String[] displayValues = (String[])Arrays.stream(constants).map(((EnumController)this.option.controller()).formatter()::apply).map(class_2561::getString).toArray(String[]::new);
                GuiOptionEditorDropdown editor = new GuiOptionEditorDropdown(this, displayValues, true);
                ((GuiOptionEditorDropdownAccessor)((Object)editor)).setConstants(constants);
                return editor;
            }
        };
    }

    private static BiFunction<Integer, MoulConfigDefinition, DandelionProcessedEditableOption<?>> createFloatFieldOption(Option<Float> option) {
        return (accordionId, configDefinition) -> new DandelionProcessedEditableOption<Float>(option, accordionId.intValue(), (Config)configDefinition){

            @Override
            protected GuiOptionEditor createEditor() {
                FloatController controller = (FloatController)this.option.controller();
                return new DandelionNumberFieldEditor(this, ((Float)controller.min()).floatValue(), ((Float)controller.max()).floatValue(), ((Float)this.option.binding().defaultValue()).floatValue());
            }
        };
    }

    private static BiFunction<Integer, MoulConfigDefinition, DandelionProcessedEditableOption<?>> createFloatSliderOption(Option<Float> option) {
        return (accordionId, configDefinition) -> new DandelionProcessedEditableOption<Float>(option, accordionId.intValue(), (Config)configDefinition){

            @Override
            protected GuiOptionEditor createEditor() {
                FloatController controller = (FloatController)this.option.controller();
                return new DandelionNumberSliderEditor(this, ((Float)controller.min()).floatValue(), ((Float)controller.max()).floatValue(), ((Float)controller.step()).floatValue());
            }
        };
    }

    private static BiFunction<Integer, MoulConfigDefinition, DandelionProcessedEditableOption<?>> createIntegerFieldOption(Option<Integer> option) {
        return (accordionId, configDefinition) -> new DandelionProcessedEditableOption<Integer>(option, accordionId.intValue(), (Config)configDefinition){

            @Override
            public Object get() {
                return Float.valueOf(((Integer)super.get()).floatValue());
            }

            @Override
            public boolean set(Object value) {
                return super.set(((Float)value).intValue());
            }

            @Override
            protected GuiOptionEditor createEditor() {
                IntegerController controller = (IntegerController)this.option.controller();
                return new DandelionNumberFieldEditor(this, ((Integer)controller.min()).intValue(), ((Integer)controller.max()).intValue(), ((Integer)this.option.binding().defaultValue()).intValue());
            }
        };
    }

    private static BiFunction<Integer, MoulConfigDefinition, DandelionProcessedEditableOption<?>> createIntegerSliderOption(Option<Integer> option) {
        return (accordionId, configDefinition) -> new DandelionProcessedEditableOption<Integer>(option, accordionId.intValue(), (Config)configDefinition){

            @Override
            public Object get() {
                return Float.valueOf(((Integer)super.get()).floatValue());
            }

            @Override
            public boolean set(Object value) {
                return super.set(((Float)value).intValue());
            }

            @Override
            protected GuiOptionEditor createEditor() {
                IntegerController controller = (IntegerController)this.option.controller();
                return new DandelionNumberSliderEditor(this, ((Integer)controller.min()).intValue(), ((Integer)controller.max()).intValue(), ((Integer)controller.step()).intValue());
            }
        };
    }

    private static BiFunction<Integer, MoulConfigDefinition, DandelionProcessedEditableOption<?>> createItemOption(Option<class_1792> option) {
        return (accordionId, configDefinition) -> new DandelionProcessedEditableOption<class_1792>(option, accordionId.intValue(), (Config)configDefinition){

            @Override
            protected GuiOptionEditor createEditor() {
                return new DandelionItemEditor(this);
            }
        };
    }

    private static BiFunction<Integer, MoulConfigDefinition, DandelionProcessedEditableOption<?>> createStringOption(Option<String> option) {
        return (accordionId, configDefinition) -> new DandelionProcessedEditableOption<String>(option, accordionId.intValue(), (Config)configDefinition){

            @Override
            protected GuiOptionEditor createEditor() {
                return new GuiOptionEditorText(this);
            }
        };
    }
}

