/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.networth;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.ToDoubleFunction;
import java.util.stream.DoubleStream;
import net.azureaaron.networth.Calculation;
import net.azureaaron.networth.NetworthResult;
import net.azureaaron.networth.PetCalculator;
import net.azureaaron.networth.data.ModifierValues;
import net.azureaaron.networth.data.SkyblockItemData;
import net.azureaaron.networth.item.Gemstone;
import net.azureaaron.networth.item.ItemMetadata;
import net.azureaaron.networth.item.SkyblockItemStack;
import net.azureaaron.networth.utils.ItemConstants;
import net.azureaaron.networth.utils.PrestigeConstants;

public class ItemCalculator {
    private ItemCalculator() {
    }

    public static NetworthResult calculate(SkyblockItemStack stack, ToDoubleFunction<String> prices, Object2ObjectMap<String, SkyblockItemData> skyblockItems) {
        return ItemCalculator.calculate(stack, prices, skyblockItems, ModifierValues.DEFAULT);
    }

    public static NetworthResult calculate(SkyblockItemStack stack, ToDoubleFunction<String> prices, Object2ObjectMap<String, SkyblockItemData> skyblockItems, ModifierValues modifiers) {
        boolean hasUpgradeCosts;
        Object2IntMap.Entry rune;
        String runeItemId;
        Calculation calculation;
        double scaledPricePaid;
        String first;
        Object itemId = stack.id();
        SkyblockItemData skyblockItemData = (SkyblockItemData)skyblockItems.get(itemId);
        ItemMetadata meta = stack.metadata();
        ArrayList<Calculation> calculations = new ArrayList<Calculation>();
        if (((String)itemId).equals("PET")) {
            return PetCalculator.calculate(meta.petInfo(), prices, modifiers);
        }
        if ((((String)itemId).equals("RUNE") || ((String)itemId).equals("UNIQUE_RUNE")) && meta.cosmetics().runes().isPresent() && meta.cosmetics().runes().get().size() > 0) {
            first = (Object2IntMap.Entry)meta.cosmetics().runes().get().object2IntEntrySet().iterator().next();
            itemId = ((String)first.getKey()).toUpperCase(Locale.CANADA) + "_RUNE_" + first.getIntValue();
        }
        String string = itemId;
        Objects.requireNonNull(string);
        first = string;
        int n = 0;
        block17: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, String.class, String.class, String.class}, (Object)first, n)) {
                case 0: {
                    String s2 = first;
                    if (!s2.equals("NEW_YEAR_CAKE") || !meta.limitedEditionInfo().newYearCakeYear().isPresent()) {
                        n = 1;
                        continue block17;
                    }
                    itemId = (String)itemId + "_" + meta.limitedEditionInfo().newYearCakeYear().getAsInt();
                    break block17;
                }
                case 1: {
                    String s3 = first;
                    if (!ItemConstants.COLOURED_ANNIVERSARY_ITEMS.contains(s3) || !meta.limitedEditionInfo().partyHatColour().isPresent()) {
                        n = 2;
                        continue block17;
                    }
                    itemId = (String)itemId + "_" + meta.limitedEditionInfo().partyHatColour().get().toUpperCase(Locale.CANADA);
                    break block17;
                }
                case 2: {
                    String s4 = first;
                    if (!s4.equals("PARTY_HAT_SLOTH") || !meta.limitedEditionInfo().partyHatEmoji().isPresent()) {
                        n = 3;
                        continue block17;
                    }
                    itemId = (String)itemId + "_" + meta.limitedEditionInfo().partyHatEmoji().get().toUpperCase(Locale.CANADA);
                    break block17;
                }
                case 3: {
                    String s5 = first;
                    if (!s5.equals("ABICASE") || !meta.limitedEditionInfo().abicaseModel().isPresent()) {
                        n = 4;
                        continue block17;
                    }
                    itemId = (String)itemId + "_" + meta.limitedEditionInfo().abicaseModel().get().toUpperCase(Locale.CANADA);
                    break block17;
                }
            }
            break;
        }
        if (meta.cosmetics().shiny()) {
            itemId = "SHINY_" + (String)itemId;
        }
        double price = prices.applyAsDouble((String)itemId) * (double)stack.count();
        double base = prices.applyAsDouble((String)itemId) * (double)stack.count();
        if (price == 0.0 && meta.auctionBidInfo().price().isPresent()) {
            price = (double)meta.auctionBidInfo().price().getAsLong() * 0.85;
            base = (double)meta.auctionBidInfo().price().getAsLong() * 0.85;
        }
        if (((String)itemId).equals("PICKONIMBUS") && meta.drillInfo().pickonimbusDurability().isPresent()) {
            double reduction = (double)meta.drillInfo().pickonimbusDurability().getAsInt() / 2000.0;
            price += price * (reduction - 1.0);
            base += price * (reduction - 1.0);
        }
        if (!((String)itemId).equals("ATTRIBUTE_SHARD") && !meta.attributes().isEmpty()) {
            List<String> sortedAttributes = meta.attributes().keySet().stream().map(s -> s.toUpperCase(Locale.CANADA)).sorted(String::compareTo).toList();
            Object baseId = ((String)itemId).replaceAll("(?:(?:HOT|BURNING|FIERY|INFERNAL)_)", "");
            Object godRollId = baseId = (String)baseId + "-" + String.join((CharSequence)"-", (Iterable<? extends CharSequence>)sortedAttributes);
            double godRollPrice = prices.applyAsDouble((String)godRollId);
            if (godRollPrice > price) {
                price = godRollPrice;
                base = godRollPrice;
                calculations.add(Calculation.of(Calculation.Type.GOD_ROLL, (String)godRollId, godRollPrice));
            }
        }
        if (price == 0.0 && PrestigeConstants.PRESTIGES.containsKey(itemId)) {
            for (String prestigeItemId : (Set)PrestigeConstants.PRESTIGES.get(itemId)) {
                SkyblockItemData itemData = (SkyblockItemData)skyblockItems.get((Object)prestigeItemId);
                if (itemData == null) continue;
                if (itemData.upgradeCosts().isPresent()) {
                    price += ItemCalculator.upgradeCosts(prices, calculations, itemData.upgradeCosts().get(), prestigeItemId, modifiers);
                }
                if (!itemData.prestige().isPresent()) continue;
                price += ItemCalculator.upgradeCosts(prices, calculations, itemData.prestige().get().costs(), prestigeItemId, modifiers);
            }
        }
        if (meta.auctionBidInfo().price().isPresent() && meta.auctionBidInfo().auction().isPresent() && meta.auctionBidInfo().bid().isPresent() && (scaledPricePaid = (double)meta.auctionBidInfo().price().getAsLong() * modifiers.regular().getDouble((Object)"shensAuctionPrice")) > price) {
            price = scaledPricePaid;
            calculations.add(Calculation.of(Calculation.Type.SHEN_AUCTION, (String)itemId, scaledPricePaid));
        }
        if (((String)itemId).equals("MIDAS_STAFF") || ((String)itemId).equals("MIDAS_SWORD")) {
            int maxBid;
            int n2 = maxBid = ((String)itemId).equals("MIDAS_SWORD") ? 50000000 : 100000000;
            if (meta.auctionBidInfo().winningBid().isPresent()) {
                if (meta.auctionBidInfo().winningBid().getAsLong() >= (long)maxBid) {
                    String maxItem = ((String)itemId).equals("MIDAS_SWORD") ? "MIDAS_SWORD_50M" : "MIDAS_STAFF_100M";
                    calculation = Calculation.of(Calculation.Type.WINNING_BID, maxItem, prices.applyAsDouble(maxItem));
                    price = calculation.price();
                    calculations.add(calculation);
                } else {
                    Calculation calculation2 = Calculation.of(Calculation.Type.WINNING_BID, (String)itemId, (double)meta.auctionBidInfo().winningBid().getAsLong() * modifiers.regular().getDouble((Object)"winningBid"));
                    price = calculation2.price();
                    calculations.add(calculation2);
                }
            }
        }
        if (!meta.enchantments().isEmpty() && ((String)itemId).equals("ENCHANTED_BOOK")) {
            boolean multiEnchantmentBook;
            boolean bl = multiEnchantmentBook = meta.enchantments().size() > 1;
            if (!multiEnchantmentBook) {
                Object2IntMap.Entry first2 = (Object2IntMap.Entry)meta.enchantments().object2IntEntrySet().iterator().next();
                String enchantmentApiName = ((String)first2.getKey()).toUpperCase(Locale.CANADA) + "_" + first2.getIntValue();
                Calculation calculation3 = Calculation.of(Calculation.Type.ENCHANTMENT, enchantmentApiName, prices.applyAsDouble("ENCHANTMENT_" + enchantmentApiName));
                price = calculation3.price();
                calculations.add(calculation3);
            } else {
                double enchantmentsPrice = 0.0;
                for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(meta.enchantments())) {
                    String enchantmentApiName = ((String)entry.getKey()).toUpperCase(Locale.CANADA) + "_" + entry.getIntValue();
                    Calculation calculation4 = Calculation.of(Calculation.Type.ENCHANTMENT, enchantmentApiName, prices.applyAsDouble("ENCHANTMENT_" + enchantmentApiName) * modifiers.regular().getDouble((Object)"enchantments"));
                    enchantmentsPrice += calculation4.price();
                    calculations.add(calculation4);
                }
                price = enchantmentsPrice;
            }
        }
        if (meta.cosmetics().skin().isPresent()) {
            Calculation calculation5 = Calculation.of(Calculation.Type.SKIN, meta.cosmetics().skin().get(), prices.applyAsDouble(meta.cosmetics().skin().get()) * modifiers.regular().getDouble((Object)"skins"));
            price += calculation5.price();
            calculations.add(calculation5);
        }
        if (!meta.enchantments().isEmpty() && !((String)itemId).equals("ENCHANTED_BOOK")) {
            for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(meta.enchantments())) {
                double d;
                int silexes;
                String enchantmentId = ((String)entry.getKey()).toUpperCase(Locale.CANADA);
                int level = entry.getIntValue();
                if (ItemConstants.BLOCKED_ENCHANTMENTS.containsKey(itemId) && ItemConstants.BLOCKED_ENCHANTMENTS.get(itemId).contains(enchantmentId) || ItemConstants.IGNORED_ENCHANTMENTS.containsKey((Object)enchantmentId) && ItemConstants.IGNORED_ENCHANTMENTS.getInt((Object)enchantmentId) == level) continue;
                if (ItemConstants.STACKING_ENCHANTMENTS.contains(enchantmentId)) {
                    level = 1;
                }
                if (enchantmentId.equals("EFFICIENCY") && level > 5 && !ItemConstants.IGNORE_SILEX.contains(itemId) && (silexes = level - 5) > 0) {
                    Calculation calculation6 = Calculation.of(Calculation.Type.SILEX, "SIL_EX", prices.applyAsDouble("SIL_EX") * (double)silexes * modifiers.regular().getDouble((Object)"silex"), silexes);
                    price += calculation6.price();
                    calculations.add(calculation6);
                }
                if (enchantmentId.equals("SCAVENGER") && level == 6) {
                    Calculation calculation7 = Calculation.of(Calculation.Type.GOLDEN_BOUNTY, "GOLDEN_BOUNTY", prices.applyAsDouble("GOLDEN_BOUNTY") * modifiers.regular().getDouble((Object)"goldenBounty"));
                    price += calculation7.price();
                    calculations.add(calculation7);
                }
                double enchantmentWorth = modifiers.enchantments().getOrDefault((Object)enchantmentId, modifiers.regular().getDouble((Object)"enchantments"));
                Objects.requireNonNull(enchantmentId);
                int n3 = 0;
                block21: while (true) {
                    String string2;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class}, (Object)string2, n3)) {
                        case 0: {
                            String s6 = string2;
                            if (!s6.startsWith("ULTIMATE")) {
                                n3 = 1;
                                continue block21;
                            }
                            int lvl1BooksNeeded = (int)Math.pow(2.0, level - 1);
                            double directPrice = prices.applyAsDouble("ENCHANTMENT_" + enchantmentId + "_" + level);
                            double priceFromLvl1s = prices.applyAsDouble("ENCHANTMENT_" + enchantmentId + "_1") * (double)lvl1BooksNeeded;
                            if (priceFromLvl1s > directPrice) {
                                d = priceFromLvl1s;
                                break block21;
                            }
                            d = directPrice;
                            break block21;
                        }
                        default: {
                            d = prices.applyAsDouble("ENCHANTMENT_" + enchantmentId + "_" + level);
                            break block21;
                        }
                    }
                    break;
                }
                double enchantmentPrice = d;
                Calculation calculation8 = Calculation.of(Calculation.Type.ENCHANTMENT, enchantmentId + "_" + level, enchantmentPrice * enchantmentWorth);
                price += calculation8.price();
                calculations.add(calculation8);
            }
        }
        if (!meta.attributes().isEmpty()) {
            for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(meta.attributes())) {
                String attribute = ((String)entry.getKey()).toUpperCase(Locale.CANADA);
                int tier = entry.getIntValue();
                int shards = (int)(Math.pow(2.0, tier - 1) - 1.0);
                String baseAttributeId = "ATTRIBUTE_SHARD-" + attribute + "_";
                DoubleStream attributePrices = DoubleStream.of(prices.applyAsDouble((String)baseAttributeId + "1"), prices.applyAsDouble((String)baseAttributeId + "2") / 2.0, prices.applyAsDouble((String)baseAttributeId + "3") / 4.0);
                double baseAttributePrice = attributePrices.filter(shardPrice -> shardPrice > 0.0).min().orElse(0.0);
                if (ItemConstants.ATTRIBUTE_BASE_COSTS.containsKey(itemId) && prices.applyAsDouble(ItemConstants.ATTRIBUTE_BASE_COSTS.get(itemId)) < baseAttributePrice) {
                    baseAttributePrice = prices.applyAsDouble(ItemConstants.ATTRIBUTE_BASE_COSTS.get(itemId));
                }
                if (ItemConstants.KUUDRA_HELMETS.contains(itemId) && prices.applyAsDouble("KUUDRA_HELMET_" + attribute) < baseAttributePrice) {
                    baseAttributePrice = prices.applyAsDouble("KUUDRA_HELMET_" + attribute);
                } else if (ItemConstants.KUUDRA_OTHERS.contains(itemId)) {
                    double[] dArray = new double[]{prices.applyAsDouble("KUUDRA_CHESTPLATE_" + attribute), prices.applyAsDouble("KUUDRA_LEGGINGS_" + attribute), prices.applyAsDouble("KUUDRA_BOOTS_" + attribute)};
                    DoubleStream kuudraArmourPrices = DoubleStream.of(dArray);
                    double meanArmourPrice = kuudraArmourPrices.average().orElse(0.0);
                    if (meanArmourPrice > 0.0 && (baseAttributePrice <= 0.0 || meanArmourPrice < baseAttributePrice)) {
                        baseAttributePrice = meanArmourPrice;
                    }
                }
                Calculation calculation9 = Calculation.of(Calculation.Type.ATTRIBUTE, attribute + "_" + tier, baseAttributePrice * (double)shards * modifiers.regular().getDouble((Object)"attributes"));
                price += calculation9.price();
                calculations.add(calculation9);
            }
        }
        if (meta.miscModifiers().pocketSackInASacks().isPresent()) {
            Calculation calculation10 = Calculation.of(Calculation.Type.POCKET_SACK_IN_A_SACK, "POCKET_SACK_IN_A_SACK", prices.applyAsDouble("POCKET_SACK_IN_A_SACK") * (double)meta.miscModifiers().pocketSackInASacks().getAsInt() * modifiers.regular().getDouble((Object)"pocketSackInASack"), meta.miscModifiers().pocketSackInASacks().getAsInt());
            price += calculation10.price();
            calculations.add(calculation10);
        }
        if (meta.gearUpgrades().woodSingularities().isPresent()) {
            Calculation calculation11 = Calculation.of(Calculation.Type.WOOD_SINGULARITY, "WOOD_SINGULARITY", prices.applyAsDouble("WOOD_SINGULARITY") * (double)meta.gearUpgrades().woodSingularities().getAsInt() * modifiers.regular().getDouble((Object)"woodSingularity"), meta.gearUpgrades().woodSingularities().getAsInt());
            price += calculation11.price();
            calculations.add(calculation11);
        }
        if (meta.miscModifiers().jalapenoBooks().isPresent()) {
            Calculation calculation12 = Calculation.of(Calculation.Type.JALAPENO_BOOK, "JALAPENO_BOOK", prices.applyAsDouble("JALAPENO_BOOK") * (double)meta.miscModifiers().jalapenoBooks().getAsInt() * modifiers.regular().getDouble((Object)"jalapenoBook"), meta.miscModifiers().jalapenoBooks().getAsInt());
            price += calculation12.price();
            calculations.add(calculation12);
        }
        if (meta.miscModifiers().transmissionTuners().isPresent()) {
            Calculation calculation13 = Calculation.of(Calculation.Type.TRANSMISSION_TUNER, "TRANSMISSION_TUNER", prices.applyAsDouble("TRANSMISSION_TUNER") * (double)meta.miscModifiers().transmissionTuners().getAsInt() * modifiers.regular().getDouble((Object)"transmissionTuner"), meta.miscModifiers().transmissionTuners().getAsInt());
            price += calculation13.price();
            calculations.add(calculation13);
        }
        if (meta.miscModifiers().manaDisintegrators().isPresent()) {
            Calculation calculation14 = Calculation.of(Calculation.Type.MANA_DISINTEGRATOR, "MANA_DISINTEGRATOR", prices.applyAsDouble("MANA_DISINTEGRATOR") * (double)meta.miscModifiers().manaDisintegrators().getAsInt() * modifiers.regular().getDouble((Object)"manaDisintegrator"), meta.miscModifiers().manaDisintegrators().getAsInt());
            price += calculation14.price();
            calculations.add(calculation14);
        }
        if (meta.accessoryUpgrades().thunderCharges().isPresent() && ((String)itemId).equals("PULSE_RING")) {
            int thunderBottlesUsed = Math.floorDiv(meta.accessoryUpgrades().thunderCharges().getAsInt(), 50000);
            Calculation calculation15 = Calculation.of(Calculation.Type.THUNDER_IN_A_BOTTLE, "THUNDER_IN_A_BOTTLE", prices.applyAsDouble("THUNDER_IN_A_BOTTLE") * (double)thunderBottlesUsed * modifiers.regular().getDouble((Object)"thunderInABottle"), thunderBottlesUsed);
            price += calculation15.price();
            calculations.add(calculation15);
        }
        if (meta.cosmetics().runes().isPresent() && !meta.cosmetics().runes().get().isEmpty() && !((String)itemId).contains("RUNE") && ItemConstants.VALID_RUNES.contains(runeItemId = ((String)(rune = (Object2IntMap.Entry)meta.cosmetics().runes().get().object2IntEntrySet().iterator().next()).getKey()).toUpperCase(Locale.CANADA) + "_RUNE_" + rune.getIntValue())) {
            calculation = Calculation.of(Calculation.Type.RUNE, runeItemId, prices.applyAsDouble(runeItemId) * modifiers.regular().getDouble((Object)"runes"));
            price += calculation.price();
            calculations.add(calculation);
        }
        if (meta.gearUpgrades().hotPotatoes().isPresent()) {
            int hotPotatoes = meta.gearUpgrades().hotPotatoes().getAsInt();
            if (hotPotatoes > 10) {
                int fumingPotatoBooksUsed = hotPotatoes - 10;
                calculation = Calculation.of(Calculation.Type.FUMING_POTATO_BOOK, "FUMING_POTATO_BOOK", prices.applyAsDouble("FUMING_POTATO_BOOK") * (double)fumingPotatoBooksUsed * modifiers.regular().getDouble((Object)"fumingPotatoBook"), fumingPotatoBooksUsed);
                price += calculation.price();
                calculations.add(calculation);
            }
            int hotPotatoBooksUsed = Math.min(hotPotatoes, 10);
            calculation = Calculation.of(Calculation.Type.HOT_POTATO_BOOK, "HOT_POTATO_BOOK", prices.applyAsDouble("HOT_POTATO_BOOK") * (double)hotPotatoBooksUsed * modifiers.regular().getDouble((Object)"hotPotatoBook"), hotPotatoBooksUsed);
            price += calculation.price();
            calculations.add(calculation);
        }
        if (meta.cosmetics().dye().isPresent()) {
            Calculation calculation16 = Calculation.of(Calculation.Type.DYE, meta.cosmetics().dye().get(), prices.applyAsDouble(meta.cosmetics().dye().get()) * modifiers.regular().getDouble((Object)"dye"));
            price += calculation16.price();
            calculations.add(calculation16);
        }
        if (meta.gearUpgrades().artOfWars().isPresent()) {
            Calculation calculation17 = Calculation.of(Calculation.Type.ART_OF_WAR, "THE_ART_OF_WAR", prices.applyAsDouble("THE_ART_OF_WAR") * (double)meta.gearUpgrades().artOfWars().getAsInt() * modifiers.regular().getDouble((Object)"artOfWar"), meta.gearUpgrades().artOfWars().getAsInt());
            price += calculation17.price();
            calculations.add(calculation17);
        }
        if (meta.gearUpgrades().artOfPeaces().isPresent()) {
            Calculation calculation18 = Calculation.of(Calculation.Type.ART_OF_PEACE, "THE_ART_OF_PEACE", prices.applyAsDouble("THE_ART_OF_PEACE") * (double)meta.gearUpgrades().artOfPeaces().getAsInt() * modifiers.regular().getDouble((Object)"artOfPeace"), meta.gearUpgrades().artOfPeaces().getAsInt());
            price += calculation18.price();
            calculations.add(calculation18);
        }
        if (meta.miscModifiers().farming4Dummies().isPresent()) {
            Calculation calculation19 = Calculation.of(Calculation.Type.FARMING_FOR_DUMMIES, "FARMING_FOR_DUMMIES", prices.applyAsDouble("FARMING_FOR_DUMMIES") * (double)meta.miscModifiers().farming4Dummies().getAsInt() * modifiers.regular().getDouble((Object)"farming4Dummies"), meta.miscModifiers().farming4Dummies().getAsInt());
            price += calculation19.price();
            calculations.add(calculation19);
        }
        if (meta.accessoryUpgrades().enrichment().isPresent()) {
            double enrichmentPrice = ItemConstants.ENRICHMENTS.stream().mapToDouble(prices::applyAsDouble).min().getAsDouble();
            calculation = Calculation.of(Calculation.Type.TALISMAN_ENRICHMENT, "TALISMAN_ENRICHMENT", enrichmentPrice * modifiers.regular().getDouble((Object)"enrichment"));
            price += calculation.price();
            calculations.add(calculation);
        }
        if (meta.rarityUpgrades() > 0 && meta.dungeonUpgrades().itemTier().isEmpty()) {
            Calculation calculation20 = Calculation.of(Calculation.Type.RECOMBOBULATOR, "RECOMBOBULATOR_3000", prices.applyAsDouble("RECOMBOBULATOR_3000") * (double)meta.rarityUpgrades() * modifiers.regular().getDouble((Object)"recombobulator"), meta.rarityUpgrades());
            price += calculation20.price();
            calculations.add(calculation20);
        }
        if (!(meta.gemstoneSlots().isEmpty() && meta.gemstones().isEmpty() || skyblockItemData == null || !skyblockItemData.gemstoneSlots().isPresent())) {
            ArrayList<String> unlockedSlotsOnItem = new ArrayList<String>(meta.gemstoneSlots());
            ArrayList<String> unlockedSlots = new ArrayList<String>();
            ArrayList<AppliedGemstone> appliedGemstones = new ArrayList<AppliedGemstone>();
            for (SkyblockItemData.GemstoneSlot slot : skyblockItemData.gemstoneSlots().get()) {
                Optional<String> key;
                if (!slot.costs().isEmpty() && !unlockedSlotsOnItem.isEmpty()) {
                    for (String type : unlockedSlotsOnItem) {
                        if (!type.startsWith(slot.type())) continue;
                        unlockedSlots.add(slot.type());
                        unlockedSlotsOnItem.remove(type);
                        break;
                    }
                }
                if (slot.costs().isEmpty()) {
                    unlockedSlots.add(slot.type());
                }
                if (!(key = meta.gemstones().keySet().stream().filter(k -> k.startsWith(slot.type()) && !k.endsWith("_gem")).findFirst()).isPresent()) continue;
                String gemstoneType = ItemConstants.GEMSTONE_GROUP_SLOT_TYPES.contains(slot.type()) ? (String)meta.gemstones().get(key.get() + "_gem").left().get() : slot.type();
                Either<String, Gemstone> gemstone = meta.gemstones().get(key.get());
                String gemstoneQuality = gemstone.right().isPresent() ? ((Gemstone)gemstone.right().get()).quality() : (String)gemstone.left().get();
                appliedGemstones.add(new AppliedGemstone(gemstoneType, gemstoneQuality, slot.type()));
                meta.gemstones().remove(key.get());
                if (slot.costs().isEmpty() || !meta.gemstoneSlots().isEmpty()) continue;
                unlockedSlots.add(slot.type());
            }
            boolean isDivansPiece = ItemConstants.DIVAN_GEAR.contains(itemId);
            if (isDivansPiece || ItemConstants.KUUDRA_ARMOUR.contains(itemId)) {
                double applicationValue = isDivansPiece ? modifiers.regular().getDouble((Object)"gemstoneChambers") : modifiers.regular().getDouble((Object)"gemstoneSlots");
                ArrayList gemstoneSlots = new ArrayList(skyblockItemData.gemstoneSlots().get());
                for (String unlockedSlot : unlockedSlots) {
                    Optional<SkyblockItemData.GemstoneSlot> slot = gemstoneSlots.stream().filter(s -> s.type().equals(unlockedSlot)).findFirst();
                    if (!slot.isPresent()) continue;
                    int total = 0;
                    for (SkyblockItemData.GemstoneSlot.GemstoneSlotCost cost : slot.get().costs().orElse(List.of())) {
                        switch (cost.type()) {
                            case "COINS": {
                                total += cost.coins().getAsInt();
                                break;
                            }
                            case "ITEM": {
                                total = (int)((double)total + prices.applyAsDouble(cost.itemId().get()) * (double)cost.amount().getAsInt());
                            }
                        }
                    }
                    Calculation calculation21 = Calculation.of(Calculation.Type.GEMSTONE_SLOT, "GEMSTONE_SLOT", (double)total * applicationValue);
                    price += calculation21.price();
                    calculations.add(calculation21);
                    gemstoneSlots.remove(slot.get());
                }
            }
            for (AppliedGemstone gemstone : appliedGemstones) {
                String gemstoneId = (gemstone.quality() + "_" + gemstone.gemstoneType() + "_GEM").toUpperCase(Locale.CANADA);
                Calculation calculation22 = Calculation.of(Calculation.Type.GEMSTONE, gemstoneId, prices.applyAsDouble(gemstoneId) * modifiers.regular().getDouble((Object)"gemstones"));
                price += calculation22.price();
                calculations.add(calculation22);
            }
        }
        if (meta.gearUpgrades().powerScroll().isPresent()) {
            Calculation calculation23 = Calculation.of(Calculation.Type.POWER_SCROLL, meta.gearUpgrades().powerScroll().get(), prices.applyAsDouble(meta.gearUpgrades().powerScroll().get()) * modifiers.regular().getDouble((Object)"powerScroll"));
            price += calculation23.price();
            calculations.add(calculation23);
        }
        if (meta.reforge().isPresent()) {
            boolean isAccessory;
            boolean bl = isAccessory = skyblockItemData != null && skyblockItemData.category().isPresent() && skyblockItemData.category().orElse("").equals("ACCESSORY");
            if (!isAccessory) {
                Calculation calculation24 = Calculation.of(Calculation.Type.REFORGE, meta.reforge().get(), prices.applyAsDouble((String)ItemConstants.REFORGES.get((Object)meta.reforge().get())) * modifiers.regular().getDouble((Object)"reforge"));
                price += calculation24.price();
                calculations.add(calculation24);
            }
        }
        int dungeonItemLevel = meta.dungeonUpgrades().itemLevel().orElse(0);
        int upgradeLevel = meta.upgradeLevel();
        boolean bl = hasUpgradeCosts = skyblockItemData != null && skyblockItemData.upgradeCosts().isPresent();
        if (hasUpgradeCosts && (dungeonItemLevel > 5 || upgradeLevel > 5)) {
            int starsUsedDungeons = dungeonItemLevel - 5;
            int starsUsedUpgrade = upgradeLevel - 5;
            int starsUsed = Math.max(starsUsedDungeons, starsUsedUpgrade);
            List<List<SkyblockItemData.GearUpgrade>> upgradeCosts = skyblockItemData.upgradeCosts().get();
            if (upgradeCosts.size() <= 5) {
                for (int i = 0; i < starsUsed; ++i) {
                    String masterStarId = ItemConstants.MASTER_STARS.get(i);
                    Calculation calculation25 = Calculation.of(Calculation.Type.MASTER_STAR, masterStarId, prices.applyAsDouble(masterStarId) * modifiers.regular().getDouble((Object)"masterStars"));
                    price += calculation25.price();
                    calculations.add(calculation25);
                }
            }
        }
        if (hasUpgradeCosts && (dungeonItemLevel > 0 || upgradeLevel > 0)) {
            int level = Math.max(dungeonItemLevel, upgradeLevel);
            List<List<SkyblockItemData.GearUpgrade>> upgradeCosts = skyblockItemData.upgradeCosts().get();
            price += ItemCalculator.upgradeCosts(prices, calculations, upgradeCosts.subList(0, Math.min(level + 1, upgradeCosts.size())), null, modifiers);
        }
        if (meta.dungeonUpgrades().abilityScrolls().isPresent()) {
            for (String scroll : meta.dungeonUpgrades().abilityScrolls().get()) {
                Calculation calculation26 = Calculation.of(Calculation.Type.WITHER_BLADE_SCROLL, scroll, prices.applyAsDouble(scroll) * modifiers.regular().getDouble((Object)"witherScroll"));
                price += calculation26.price();
                calculations.add(calculation26);
            }
        }
        if (meta.drillInfo().isAnyDrillPartPresent()) {
            if (meta.drillInfo().fuelTank().isPresent()) {
                Calculation calculation27 = Calculation.of(Calculation.Type.DRILL_PART, meta.drillInfo().fuelTank().get().toUpperCase(Locale.CANADA), prices.applyAsDouble(meta.drillInfo().fuelTank().get().toUpperCase(Locale.CANADA)) * modifiers.regular().getDouble((Object)"drillPart"));
                price += calculation27.price();
                calculations.add(calculation27);
            }
            if (meta.drillInfo().engine().isPresent()) {
                Calculation calculation28 = Calculation.of(Calculation.Type.DRILL_PART, meta.drillInfo().engine().get().toUpperCase(Locale.CANADA), prices.applyAsDouble(meta.drillInfo().engine().get().toUpperCase(Locale.CANADA)) * modifiers.regular().getDouble((Object)"drillPart"));
                price += calculation28.price();
                calculations.add(calculation28);
            }
            if (meta.drillInfo().upgradeModule().isPresent()) {
                Calculation calculation29 = Calculation.of(Calculation.Type.DRILL_PART, meta.drillInfo().upgradeModule().get().toUpperCase(Locale.CANADA), prices.applyAsDouble(meta.drillInfo().upgradeModule().get().toUpperCase(Locale.CANADA)) * modifiers.regular().getDouble((Object)"drillPart"));
                price += calculation29.price();
                calculations.add(calculation29);
            }
            if (meta.drillInfo().polarvoids() > 0) {
                Calculation calculation30 = Calculation.of(Calculation.Type.POLARVOID_BOOK, "POLARVOID_BOOK", prices.applyAsDouble("POLARVOID_BOOK") * (double)meta.drillInfo().polarvoids() * modifiers.regular().getDouble((Object)"polarvoidBook"), meta.drillInfo().polarvoids());
                price += calculation30.price();
                calculations.add(calculation30);
            }
            if (meta.drillInfo().divanPowderCoating().isPresent()) {
                Calculation calculation31 = Calculation.of(Calculation.Type.DIVAN_POWDER_COATING, "DIVAN_POWDER_COATING", prices.applyAsDouble("DIVAN_POWDER_COATING") * (double)meta.drillInfo().divanPowderCoating().getAsInt() * modifiers.regular().getDouble((Object)"divanPowderCoating"));
                price += calculation31.price();
                calculations.add(calculation31);
            }
        }
        if (meta.miscModifiers().ethermerge().isPresent()) {
            Calculation calculation32 = Calculation.of(Calculation.Type.ETHERWARP_CONDUIT, "ETHERWARP_CONDUIT", prices.applyAsDouble("ETHERWARP_CONDUIT") * modifiers.regular().getDouble((Object)"etherwarp"));
            price += calculation32.price();
            calculations.add(calculation32);
        }
        if (((String)itemId).equals("NEW_YEAR_CAKE_BAG")) {
            double cakesPrice = 0.0;
            Object calculation26 = meta.cakeBagCakeYears().iterator();
            while (calculation26.hasNext()) {
                int year = (Integer)calculation26.next();
                cakesPrice += prices.applyAsDouble("NEW_YEAR_CAKE_" + year);
            }
            calculation26 = Calculation.of(Calculation.Type.NEW_YEAR_CAKES, "NEW_YEAR_CAKES", cakesPrice);
            price += ((Calculation)calculation26).price();
            calculations.add((Calculation)calculation26);
        }
        return NetworthResult.of(price, base, calculations);
    }

    private static <T> double upgradeCosts(ToDoubleFunction<String> prices, List<Calculation> calculations, List<T> upgradeCosts, String prestigeItem, ModifierValues modifiers) {
        double price = 0.0;
        int star = 0;
        ArrayList<Calculation> gearCalculations = new ArrayList<Calculation>();
        for (T upgrade : upgradeCosts) {
            ++star;
            Calculation calculation = null;
            if (upgrade instanceof List) {
                List upgradesList = (List)upgrade;
                for (SkyblockItemData.GearUpgrade gearUpgrade : upgradesList) {
                    calculation = ItemCalculator.upgradeCost(prices, gearUpgrade, star, modifiers);
                    gearCalculations.add(calculation);
                    if (prestigeItem != null) continue;
                    price += calculation.price();
                    calculations.add(calculation);
                }
                continue;
            }
            if (!(upgrade instanceof SkyblockItemData.GearUpgrade)) continue;
            SkyblockItemData.GearUpgrade gearUpgrade = (SkyblockItemData.GearUpgrade)upgrade;
            calculation = ItemCalculator.upgradeCost(prices, gearUpgrade, 0, modifiers);
            gearCalculations.add(calculation);
            if (prestigeItem != null) continue;
            price += calculation.price();
            calculations.add(calculation);
        }
        if (prestigeItem != null && gearCalculations.size() > 0) {
            boolean isPrestige = ((Calculation)gearCalculations.getFirst()).type() == Calculation.Type.PRESTIGE;
            double priceSum = gearCalculations.stream().mapToDouble(Calculation::price).sum();
            Calculation reduced = Calculation.of(isPrestige ? Calculation.Type.PRESTIGE : Calculation.Type.STAR, prestigeItem, priceSum, isPrestige ? 1 : star);
            double prestigeItemPrice = prices.applyAsDouble(prestigeItem);
            if (isPrestige && prestigeItemPrice != 0.0) {
                reduced = reduced.add(prestigeItemPrice);
            }
            price += reduced.price();
            calculations.add(reduced);
        }
        return price;
    }

    private static Calculation upgradeCost(ToDoubleFunction<String> prices, SkyblockItemData.GearUpgrade upgrade, int star, ModifierValues modifiers) {
        boolean isEssenceUpgrade = upgrade.essenceType().isPresent();
        double upgradePrice = isEssenceUpgrade ? prices.applyAsDouble("ESSENCE_" + upgrade.essenceType().get()) : prices.applyAsDouble(upgrade.itemId().orElse(""));
        Calculation calculation = Calculation.of(star == 0 ? Calculation.Type.PRESTIGE : Calculation.Type.STAR, (String)(isEssenceUpgrade ? "ESSENCE_" + upgrade.essenceType().get() : upgrade.itemId().get()), (double)upgrade.amount().orElse(0) * upgradePrice * (upgrade.essenceType().isPresent() ? modifiers.regular().getDouble((Object)"essence") : 1.0), upgrade.amount().orElse(0));
        return calculation;
    }

    private record AppliedGemstone(String gemstoneType, String quality, String slotType) {
    }
}

