/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.networth.item;

import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.azureaaron.networth.item.AccessoryUpgrades;
import net.azureaaron.networth.item.AuctionBidInfo;
import net.azureaaron.networth.item.Cosmetics;
import net.azureaaron.networth.item.DrillInfo;
import net.azureaaron.networth.item.DungeonUpgrades;
import net.azureaaron.networth.item.GearUpgrades;
import net.azureaaron.networth.item.Gemstone;
import net.azureaaron.networth.item.ItemMetadata;
import net.azureaaron.networth.item.ItemMetadataRetriever;
import net.azureaaron.networth.item.LimitedEditionInfo;
import net.azureaaron.networth.item.MiscModifiers;
import net.azureaaron.networth.item.PetInfo;
import net.azureaaron.networth.utils.CodecUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
record DynamicItemMetadata(Object2IntMap<String> enchantments, int rarityUpgrades, Optional<String> reforge, int upgradeLevel, DungeonUpgrades dungeonUpgrades, GearUpgrades gearUpgrades, List<String> gemstoneSlots, Map<String, Either<String, Gemstone>> gemstones, DrillInfo drillInfo, Object2IntMap<String> attributes, AuctionBidInfo auctionBidInfo, MiscModifiers miscModifiers, AccessoryUpgrades accessoryUpgrades, Cosmetics cosmetics, PetInfo petInfo, LimitedEditionInfo limitedEditionInfo, IntList cakeBagCakeYears) implements ItemMetadata
{
    private static final Codec<Object2IntMap<String>> OBJECT_2_INT_MAP_CODEC = CodecUtils.createObject2IntMapCodec(Codec.STRING);
    private static final Function<Dynamic<?>, String> STRING_MAPPER = dynamic -> dynamic.asString("");

    static DynamicItemMetadata of(Dynamic<?> customData, ItemMetadataRetriever retriever) {
        Object2IntMap enchantments = (Object2IntMap)OBJECT_2_INT_MAP_CODEC.parse(customData.get("enchantments").orElseEmptyMap()).getOrThrow();
        int rarityUpgrades = customData.get("rarity_upgrades").asInt(0);
        Optional<String> reforge = customData.get("modifier").result().map(STRING_MAPPER);
        int upgradeLevel = customData.get("upgrade_level").asInt(0);
        DungeonUpgrades dungeonUpgrades = (DungeonUpgrades)DungeonUpgrades.CODEC.parse(customData).getOrThrow();
        GearUpgrades gearUpgrades = (GearUpgrades)GearUpgrades.CODEC.parse(customData).getOrThrow();
        List gemstoneSlots = (List)Codec.STRING.listOf().parse(customData.get("gems").orElseEmptyMap().get("unlocked_slots").orElseEmptyList()).getOrThrow();
        Map gemstones = (Map)Gemstone.MAP_EITHER_CODEC.parse(customData.get("gems").orElseEmptyMap().remove("unlocked_slots")).getOrThrow();
        DrillInfo drillInfo = (DrillInfo)DrillInfo.CODEC.parse(customData).getOrThrow();
        Object2IntMap attributes = (Object2IntMap)OBJECT_2_INT_MAP_CODEC.parse(customData.get("attributes").orElseEmptyMap()).getOrThrow();
        AuctionBidInfo auctionBidInfo = (AuctionBidInfo)AuctionBidInfo.CODEC.parse(customData).getOrThrow();
        MiscModifiers miscModifiers = (MiscModifiers)MiscModifiers.CODEC.parse(customData).getOrThrow();
        AccessoryUpgrades accessoryUpgrades = (AccessoryUpgrades)AccessoryUpgrades.CODEC.parse(customData).getOrThrow();
        Cosmetics cosmetics = (Cosmetics)Cosmetics.CODEC.parse(customData).getOrThrow();
        PetInfo petInfo = customData.get("petInfo").result().map(petInfoJsonDynamic -> (PetInfo)PetInfo.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)petInfoJsonDynamic.asString(""))).setPartial((Object)PetInfo.EMPTY).getPartialOrThrow()).orElse(PetInfo.EMPTY);
        LimitedEditionInfo limitedEditionInfo = (LimitedEditionInfo)LimitedEditionInfo.CODEC.parse(customData).getOrThrow();
        IntList cakeBagCakeYears = retriever.cakeBagCakeYears();
        return new DynamicItemMetadata((Object2IntMap<String>)enchantments, rarityUpgrades, reforge, upgradeLevel, dungeonUpgrades, gearUpgrades, gemstoneSlots, gemstones, drillInfo, (Object2IntMap<String>)attributes, auctionBidInfo, miscModifiers, accessoryUpgrades, cosmetics, petInfo, limitedEditionInfo, cakeBagCakeYears);
    }
}

