/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.legacyitemdfu.fixers;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.azureaaron.legacyitemdfu.TypeReferences;
import net.azureaaron.legacyitemdfu.schemas.IdentifierNormalizingSchema;

public class BannerIdsFix
extends DataFix {
    public BannerIdsFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(TypeReferences.LEGACY_ITEM_STACK);
        OpticFinder itemIdFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)TypeReferences.ITEM_NAME.typeName(), IdentifierNormalizingSchema.getIdentifierType()));
        OpticFinder nbtTagFinder = type.findField("tag");
        OpticFinder blockEntityTagFinder = nbtTagFinder.type().findField("BlockEntityTag");
        return this.fixTypeEverywhereTyped("BannerIdsFix", type, itemStackTyped -> {
            Optional itemId = itemStackTyped.getOptional(itemIdFinder);
            if (itemId.isPresent() && ((String)((Pair)itemId.get()).getSecond()).equals("minecraft:banner")) {
                Typed nbtTagTyped;
                Optional blockEntityTagOpt;
                Dynamic stack = (Dynamic)itemStackTyped.get(DSL.remainderFinder());
                Optional nbtTagOpt = itemStackTyped.getOptionalTyped(nbtTagFinder);
                if (nbtTagOpt.isPresent() && (blockEntityTagOpt = (nbtTagTyped = (Typed)nbtTagOpt.get()).getOptionalTyped(blockEntityTagFinder)).isPresent()) {
                    Typed blockEntityTagTyped = (Typed)blockEntityTagOpt.get();
                    Dynamic blockEntityTagDynamic = (Dynamic)blockEntityTagTyped.getOrCreate(DSL.remainderFinder());
                    if (blockEntityTagDynamic.get("Base").asNumber().result().isPresent()) {
                        stack = stack.set("Damage", stack.createShort((short)(blockEntityTagDynamic.get("Base").asInt(0) & 0xF)));
                        blockEntityTagDynamic = blockEntityTagDynamic.remove("Base");
                    }
                    blockEntityTagDynamic = blockEntityTagDynamic.update("Patterns", patternsDynamic -> (Dynamic)DataFixUtils.orElse((Optional)patternsDynamic.asStreamOpt().map(stream -> stream.map(patternDynamic -> patternDynamic.update("Color", colourDynamic -> colourDynamic.createInt(15 - colourDynamic.asInt(0))))).map(arg_0 -> ((Dynamic)patternsDynamic).createList(arg_0)).result(), (Object)patternsDynamic));
                    return itemStackTyped.set(DSL.remainderFinder(), (Object)stack).set(nbtTagFinder, nbtTagTyped.set(blockEntityTagFinder, blockEntityTagTyped.set(DSL.remainderFinder(), (Object)blockEntityTagDynamic)));
                }
                return itemStackTyped.set(DSL.remainderFinder(), (Object)stack);
            }
            return itemStackTyped;
        });
    }
}

