/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.repo.constants;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class PetNumbers {
    @SerializedName(value="1")
    Stats statsAtLowLevel;
    @SerializedName(value="100")
    Stats statsAtHighLevel;
    @SerializedName(value="stats_levelling_curve")
    @ApiStatus.Obsolete
    String levelingCurve;
    private transient int minLevel;
    private transient int maxLevel;

    public int getLowLevel() {
        if (this.minLevel > 0) {
            return this.minLevel;
        }
        if (this.levelingCurve == null) {
            return 1;
        }
        String[] split = this.levelingCurve.split(":");
        assert (split.length == 3);
        assert (Objects.equals(split[2], "1"));
        this.minLevel = Integer.parseInt(split[0]);
        return this.minLevel;
    }

    public int getHighLevel() {
        if (this.maxLevel > 0) {
            return this.maxLevel;
        }
        if (this.levelingCurve == null) {
            return 100;
        }
        String[] split = this.levelingCurve.split(":");
        assert (split.length == 3);
        assert (Objects.equals(split[2], "1"));
        this.maxLevel = Integer.parseInt(split[1]);
        return this.maxLevel;
    }

    @Nullable
    public Stats interpolatedStatsAtLevel(int level) {
        Double highStat;
        Double lowStat;
        if (level < this.getLowLevel()) {
            return null;
        }
        if (level > this.getHighLevel()) {
            return null;
        }
        double progress = (double)(level - this.getLowLevel()) / (double)(this.getHighLevel() - this.getLowLevel());
        Stats stats = new Stats();
        for (String stat : this.getStatsAtLowLevel().statNumbers.keySet()) {
            lowStat = this.getStatsAtLowLevel().getStatNumbers().get(stat);
            highStat = this.getStatsAtHighLevel().getStatNumbers().get(stat);
            stats.getStatNumbers().put(stat, lowStat + (highStat - lowStat) * progress);
        }
        Iterator<Double> lowStatIt = this.getStatsAtLowLevel().getOtherNumbers().iterator();
        Iterator<Double> highStatIt = this.getStatsAtHighLevel().getOtherNumbers().iterator();
        while (lowStatIt.hasNext() && highStatIt.hasNext()) {
            lowStat = lowStatIt.next();
            highStat = highStatIt.next();
            stats.getOtherNumbers().add(lowStat + (highStat - lowStat) * progress);
        }
        return stats;
    }

    public Stats getStatsAtLowLevel() {
        return this.statsAtLowLevel;
    }

    public Stats getStatsAtHighLevel() {
        return this.statsAtHighLevel;
    }

    public String getLevelingCurve() {
        return this.levelingCurve;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public static class Stats {
        @SerializedName(value="otherNums")
        List<Double> otherNumbers = new ArrayList<Double>();
        @SerializedName(value="statNums")
        Map<String, Double> statNumbers = new HashMap<String, Double>();

        public List<Double> getOtherNumbers() {
            return this.otherNumbers;
        }

        public Map<String, Double> getStatNumbers() {
            return this.statNumbers;
        }

        public Stats(List<Double> otherNumbers, Map<String, Double> statNumbers) {
            this.otherNumbers = otherNumbers;
            this.statNumbers = statNumbers;
        }

        public String toString() {
            return "PetNumbers.Stats(otherNumbers=" + this.getOtherNumbers() + ", statNumbers=" + this.getStatNumbers() + ")";
        }

        public Stats() {
        }
    }
}

