/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.lib.Config;

public class CoreConfig {
    public static final Config.SectionParser<CoreConfig> KEY = CoreConfig::new;
    public static final boolean DEFAULT_COMMIT_GRAPH_ENABLE = false;
    private final int compression;
    private final int packIndexVersion;
    private final String excludesfile;
    private final String attributesfile;
    private final boolean commitGraph;

    private CoreConfig(Config rc) {
        this.compression = rc.getInt("core", "compression", -1);
        this.packIndexVersion = rc.getInt("pack", "indexversion", 2);
        this.excludesfile = rc.getString("core", null, "excludesfile");
        this.attributesfile = rc.getString("core", null, "attributesfile");
        this.commitGraph = rc.getBoolean("core", "commitGraph", false);
    }

    public int getCompression() {
        return this.compression;
    }

    public int getPackIndexVersion() {
        return this.packIndexVersion;
    }

    public String getExcludesFile() {
        return this.excludesfile;
    }

    public String getAttributesFile() {
        return this.attributesfile;
    }

    public boolean enableCommitGraph() {
        return this.commitGraph;
    }

    public static enum AutoCRLF {
        FALSE,
        TRUE,
        INPUT;

    }

    public static enum CheckStat {
        MINIMAL,
        DEFAULT;

    }

    public static enum EOL {
        CRLF,
        LF,
        NATIVE;

    }

    public static enum EolStreamType {
        TEXT_CRLF,
        TEXT_LF,
        AUTO_CRLF,
        AUTO_LF,
        DIRECT;

    }

    public static enum HideDotFiles {
        FALSE,
        TRUE,
        DOTGITONLY;

    }

    public static enum LogRefUpdates {
        FALSE,
        TRUE,
        ALWAYS;

    }

    public static enum SymLinks {
        FALSE,
        TRUE;

    }

    public static enum TrustLooseRefStat {
        ALWAYS,
        AFTER_OPEN;

    }

    public static enum TrustPackedRefsStat {
        NEVER,
        ALWAYS,
        AFTER_OPEN,
        UNSET;

    }
}

