/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.networth.utils;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.azureaaron.networth.utils.PrestigeConstants;
import net.azureaaron.networth.utils.Utils;

public interface ItemConstants {
    public static final Set<String> COLOURED_ANNIVERSARY_ITEMS = Set.of("PARTY_HAT_CRAB", "PARTY_HAT_CRAB_ANIMATED", "BALLOON_HAT_2024");
    public static final int PICKONIMBUS_DURABILITY = 2000;
    public static final Map<String, Set<String>> BLOCKED_ENCHANTMENTS = Map.of("BONE_BOOMERANG", Set.of("OVERLOAD", "POWER", "ULTIMATE_SOUL_EATER"), "DEATH_BOW", Set.of("OVERLOAD", "POWER", "ULTIMATE_SOUL_EATER"), "GARDENING_AXE", Set.of("REPLENISH"), "GARDENING_HOE", Set.of("REPLENISH"), "ADVANCED_GARDENING_AXE", Set.of("REPLENISH"), "ADVANCED_GARDENING_HOE", Set.of("REPLENISH"));
    public static final Object2IntMap<String> IGNORED_ENCHANTMENTS = Object2IntMaps.unmodifiable((Object2IntMap)((Object2IntMap)Utils.make(new Object2IntOpenHashMap(), map -> map.put((Object)"SCAVENGER", 5))));
    public static final Set<String> STACKING_ENCHANTMENTS = Set.of("EXPERTISE", "COMPACT", "CULTIVATING", "CHAMPION", "HECATOMB", "TOXOPHILITE");
    public static final Set<String> IGNORE_SILEX = Set.of("PROMISING_SPADE", "STONK_PICKAXE");
    public static final Map<String, String> ATTRIBUTE_BASE_COSTS = Map.of("GLOWSTONE_GAUNTLET", "GLOWSTONE_GAUNTLET", "VANQUISHED_GLOWSTONE_GAUNTLET", "GLOWSTONE_GAUNTLET", "BLAZE_BELT", "BLAZE_BELT", "VANQUISHED_BLAZE_BELT", "BLAZE_BELT", "MAGMA_NECKLACE", "MAGMA_NECKLACE", "VANQUISHED_MAGMA_NECKLACE", "MAGMA_NECKLACE", "MAGMA_ROD", "MAGMA_ROD", "INFERNO_ROD", "MAGMA_ROD", "HELLFIRE_ROD", "MAGMA_ROD");
    public static final Set<String> VALID_RUNES = Set.of("MUSIC_RUNE_1", "MUSIC_RUNE_2", "MUSIC_RUNE_3", "MEOW_MUSIC_RUNE_3", "ENCHANT_RUNE_1", "ENCHANT_RUNE_2", "ENCHANT_RUNE_3", "GRAND_SEARING_RUNE_3", "SPELLBOUND_RUNE_3", "GRAND_FREEZING_RUNE_3", "PRIMAL_FEAR_RUNE_3", "GOLDEN_CARPET_RUNE_3", "ICE_SKATES_RUNE_3", "BARK_TUNES_RUNE_3", "SMITTEN_RUNE_3", "RAINY_DAY_RUNE_3");
    public static final Set<String> ENRICHMENTS = Set.of("TALISMAN_ENRICHMENT_ATTACK_SPEED", "TALISMAN_ENRICHMENT_CRITICAL_CHANCE", "TALISMAN_ENRICHMENT_CRITICAL_DAMAGE", "TALISMAN_ENRICHMENT_DEFENSE", "TALISMAN_ENRICHMENT_FEROCITY", "TALISMAN_ENRICHMENT_HEALTH", "TALISMAN_ENRICHMENT_INTELLIGENCE", "TALISMAN_ENRICHMENT_MAGIC_FIND", "TALISMAN_ENRICHMENT_SEA_CREATURE_CHANCE", "TALISMAN_ENRICHMENT_STRENGTH", "TALISMAN_ENRICHMENT_WALK_SPEED");
    public static final Object2ObjectMap<String, String> REFORGES = Object2ObjectMaps.unmodifiable((Object2ObjectMap)((Object2ObjectMap)Utils.make(new Object2ObjectOpenHashMap(), map -> {
        map.put((Object)"stiff", (Object)"HARDENED_WOOD");
        map.put((Object)"salty", (Object)"SALT_CUBE");
        map.put((Object)"aote_stone", (Object)"AOTE_STONE");
        map.put((Object)"blazing", (Object)"BLAZEN_SPHERE");
        map.put((Object)"waxed", (Object)"BLAZE_WAX");
        map.put((Object)"rooted", (Object)"BURROWING_SPORES");
        map.put((Object)"candied", (Object)"CANDY_CORN");
        map.put((Object)"perfect", (Object)"DIAMOND_ATOM");
        map.put((Object)"fleet", (Object)"DIAMONITE");
        map.put((Object)"fabled", (Object)"DRAGON_CLAW");
        map.put((Object)"spiked", (Object)"DRAGON_SCALE");
        map.put((Object)"royal", (Object)"DWARVEN_TREASURE");
        map.put((Object)"hyper", (Object)"ENDSTONE_GEODE");
        map.put((Object)"coldfusion", (Object)"ENTROPY_SUPPRESSOR");
        map.put((Object)"blooming", (Object)"FLOWERING_BOUQUET");
        map.put((Object)"fanged", (Object)"FULL_JAW_FANGED_KIT");
        map.put((Object)"jaded", (Object)"JADERALD");
        map.put((Object)"jerry", (Object)"JERRY_STONE");
        map.put((Object)"magnetic", (Object)"LAPIS_CRYSTAL");
        map.put((Object)"earthy", (Object)"LARGE_WALNUT");
        map.put((Object)"fortified", (Object)"METEOR_SHARD");
        map.put((Object)"gilded", (Object)"MIDAS_JEWEL");
        map.put((Object)"cubic", (Object)"MOLTEN_CUBE");
        map.put((Object)"necrotic", (Object)"NECROMANCER_BROOCH");
        map.put((Object)"fruitful", (Object)"ONYX");
        map.put((Object)"precise", (Object)"OPTICAL_LENS");
        map.put((Object)"mossy", (Object)"OVERGROWN_GRASS");
        map.put((Object)"pitchin", (Object)"PITCHIN_KOI");
        map.put((Object)"undead", (Object)"PREMIUM_FLESH");
        map.put((Object)"blood_soaked", (Object)"PRESUMED_GALLON_OF_RED_PAINT");
        map.put((Object)"mithraic", (Object)"PURE_MITHRIL");
        map.put((Object)"reinforced", (Object)"RARE_DIAMOND");
        map.put((Object)"ridiculous", (Object)"RED_NOSE");
        map.put((Object)"loving", (Object)"RED_SCARF");
        map.put((Object)"auspicious", (Object)"ROCK_GEMSTONE");
        map.put((Object)"treacherous", (Object)"RUSTY_ANCHOR");
        map.put((Object)"headstrong", (Object)"SALMON_OPAL");
        map.put((Object)"strengthened", (Object)"SEARING_STONE");
        map.put((Object)"glistening", (Object)"SHINY_PRISM");
        map.put((Object)"bustling", (Object)"SKYMART_BROCHURE");
        map.put((Object)"spiritual", (Object)"SPIRIT_DECOY");
        map.put((Object)"suspicious", (Object)"SUSPICIOUS_VIAL");
        map.put((Object)"snowy", (Object)"TERRY_SNOWGLOBE");
        map.put((Object)"dimensional", (Object)"TITANIUM_TESSERACT");
        map.put((Object)"ambered", (Object)"AMBER_MATERIAL");
        map.put((Object)"beady", (Object)"BEADY_EYES");
        map.put((Object)"blessed", (Object)"BLESSED_FRUIT");
        map.put((Object)"bulky", (Object)"BULKY_STONE");
        map.put((Object)"buzzing", (Object)"CLIPPED_WINGS");
        map.put((Object)"submerged", (Object)"DEEP_SEA_ORB");
        map.put((Object)"renowned", (Object)"DRAGON_HORN");
        map.put((Object)"festive", (Object)"FROZEN_BAUBLE");
        map.put((Object)"giant", (Object)"GIANT_TOOTH");
        map.put((Object)"lustrous", (Object)"GLEAMING_CRYSTAL");
        map.put((Object)"bountiful", (Object)"GOLDEN_BALL");
        map.put((Object)"chomp", (Object)"KUUDRA_MANDIBLE");
        map.put((Object)"lucky", (Object)"LUCKY_DICE");
        map.put((Object)"stellar", (Object)"PETRIFIED_STARFALL");
        map.put((Object)"scraped", (Object)"POCKET_ICEBERG");
        map.put((Object)"ancient", (Object)"PRECURSOR_GEAR");
        map.put((Object)"refined", (Object)"REFINED_AMBER");
        map.put((Object)"empowered", (Object)"SADAN_BROOCH");
        map.put((Object)"withered", (Object)"WITHER_BLOOD");
        map.put((Object)"glacial", (Object)"FRIGID_HUSK");
        map.put((Object)"heated", (Object)"HOT_STUFF");
        map.put((Object)"dirty", (Object)"DIRT_BOTTLE");
        map.put((Object)"moil", (Object)"MOIL_LOG");
        map.put((Object)"toil", (Object)"TOIL_LOG");
        map.put((Object)"greater_spook", (Object)"BOO_STONE");
    })));
    public static final Set<String> GEMSTONE_GROUP_SLOT_TYPES = Set.of("COMBAT", "OFFENSIVE", "DEFENSIVE", "MINING", "UNIVERSAL", "CHISEL");
    public static final Set<String> DIVAN_GEAR = Set.of("DIVAN_HELMET", "DIVAN_CHESTPLATE", "DIVAN_LEGGINGS", "DIVAN_BOOTS", "DIVAN_PENDANT");
    public static final Set<String> KUUDRA_ARMOUR = ItemConstants.getKuudraArmourIds().collect(Collectors.toUnmodifiableSet());
    public static final Set<String> KUUDRA_HELMETS = ItemConstants.getKuudraArmourIds().filter(id -> id.endsWith("_HELMET")).collect(Collectors.toUnmodifiableSet());
    public static final Set<String> KUUDRA_OTHERS = ItemConstants.getKuudraArmourIds().filter(id -> !id.endsWith("_HELMET")).collect(Collectors.toUnmodifiableSet());
    public static final List<String> MASTER_STARS = List.of("FIRST_MASTER_STAR", "SECOND_MASTER_STAR", "THIRD_MASTER_STAR", "FOURTH_MASTER_STAR", "FIFTH_MASTER_STAR");

    private static Stream<String> getKuudraArmourIds() {
        ObjectOpenHashSet collectedIds = new ObjectOpenHashSet();
        for (Object2ObjectMap.Entry entry : Object2ObjectMaps.fastIterable(PrestigeConstants.PRESTIGES)) {
            collectedIds.add((Object)((String)entry.getKey()));
            for (String id : (Set)entry.getValue()) {
                collectedIds.add((Object)id);
            }
        }
        return collectedIds.stream();
    }
}

