/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.repo.constants;

import com.google.gson.annotations.SerializedName;
import io.github.moulberry.repo.data.Rarity;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class Bonuses {
    @SerializedName(value="pet_rewards")
    Map<Integer, Map<String, Float>> petRewards;
    @SerializedName(value="pet_value")
    Map<Rarity, Integer> petValue;
    @SerializedName(value="bonus_stats")
    Map<String, Map<Integer, Map<String, Float>>> bonusStats;

    public int getPetValue(Rarity rarity) {
        if (this.petValue == null) {
            return 0;
        }
        return this.petValue.getOrDefault((Object)rarity, 0);
    }

    public Map<String, Float> getPetRewards(int score) {
        if (this.petRewards == null) {
            return new HashMap<String, Float>();
        }
        return this.petRewards.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).filter(it -> (Integer)it.getKey() <= score).map(Map.Entry::getValue).reduce(new HashMap(), (a, b) -> {
            a.putAll(b);
            return a;
        });
    }

    public Map<String, Float> getAccumulativeLevelingRewards(String name, int level) {
        if (this.bonusStats == null) {
            return new HashMap<String, Float>();
        }
        Map rewardTiers = this.bonusStats.getOrDefault(name, new HashMap());
        HashMap<String, Float> rewards = new HashMap<String, Float>();
        Map currentBonuses = new HashMap();
        for (int i = 0; i <= level; ++i) {
            currentBonuses = rewardTiers.getOrDefault(i, currentBonuses);
            for (Map.Entry reward : currentBonuses.entrySet()) {
                rewards.put((String)reward.getKey(), Float.valueOf(rewards.getOrDefault(reward.getKey(), Float.valueOf(0.0f)).floatValue() + ((Float)reward.getValue()).floatValue()));
            }
        }
        return rewards;
    }

    public Map<Integer, Map<String, Float>> getPetRewards() {
        return this.petRewards;
    }

    public Map<Rarity, Integer> getPetValue() {
        return this.petValue;
    }

    public Map<String, Map<Integer, Map<String, Float>>> getBonusStats() {
        return this.bonusStats;
    }
}

