/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.legacyitemdfu;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import net.azureaaron.legacyitemdfu.fixers.AttributeIdFix;
import net.azureaaron.legacyitemdfu.fixers.BannerIdsFix;
import net.azureaaron.legacyitemdfu.fixers.BannerPatternFormatFix;
import net.azureaaron.legacyitemdfu.fixers.EnchantmentsFix;
import net.azureaaron.legacyitemdfu.fixers.ItemCustomNameAndLoreToTextFix;
import net.azureaaron.legacyitemdfu.fixers.ItemStackComponentizationFix;
import net.azureaaron.legacyitemdfu.fixers.ItemStackUuidsFix;
import net.azureaaron.legacyitemdfu.fixers.NumericItemIdFix;
import net.azureaaron.legacyitemdfu.fixers.PostFlatteningItemIdsFix;
import net.azureaaron.legacyitemdfu.fixers.SpawnEggItemIdFix;
import net.azureaaron.legacyitemdfu.fixers.TheFlatteningFix;
import net.azureaaron.legacyitemdfu.schemas.Schema1;
import net.azureaaron.legacyitemdfu.schemas.Schema11;
import net.azureaaron.legacyitemdfu.schemas.Schema2;

public class LegacyItemStackFixer {
    public static final int FIRST_VERSION = 1;
    public static final int LATEST_VERSION = 12;
    private static final DataFixer FIXER = LegacyItemStackFixer.build();

    private static DataFixer build() {
        DataFixerBuilder builder = new DataFixerBuilder(12);
        builder.addSchema(1, Schema1::new);
        Schema schema2 = builder.addSchema(2, Schema2::new);
        builder.addFixer((DataFix)new NumericItemIdFix(schema2, true));
        Schema schema3 = builder.addSchema(3, Schema::new);
        builder.addFixer((DataFix)new SpawnEggItemIdFix(schema3, true));
        Schema schema4 = builder.addSchema(4, Schema::new);
        builder.addFixer((DataFix)new BannerIdsFix(schema4, true));
        Schema schema5 = builder.addSchema(5, Schema::new);
        builder.addFixer((DataFix)new TheFlatteningFix(schema5, true));
        Schema schema6 = builder.addSchema(6, Schema::new);
        builder.addFixer((DataFix)new PostFlatteningItemIdsFix(schema6, true));
        Schema schema7 = builder.addSchema(7, Schema::new);
        builder.addFixer((DataFix)new ItemCustomNameAndLoreToTextFix(schema7, true));
        Schema schema8 = builder.addSchema(8, Schema::new);
        builder.addFixer((DataFix)new EnchantmentsFix(schema8, true));
        Schema schema9 = builder.addSchema(9, Schema::new);
        builder.addFixer((DataFix)new ItemStackUuidsFix(schema9, true));
        Schema schema10 = builder.addSchema(10, Schema::new);
        builder.addFixer((DataFix)new BannerPatternFormatFix(schema10, true));
        Schema schema11 = builder.addSchema(11, Schema11::new);
        builder.addFixer((DataFix)new ItemStackComponentizationFix(schema11, true));
        Schema schema12 = builder.addSchema(12, Schema::new);
        builder.addFixer((DataFix)new AttributeIdFix(schema12, true));
        return builder.build().fixer();
    }

    public static DataFixer getFixer() {
        return FIXER;
    }
}

