/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.legacyitemdfu.fixers;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Optional;
import net.azureaaron.legacyitemdfu.TypeReferences;
import net.azureaaron.legacyitemdfu.schemas.IdentifierNormalizingSchema;

public class SpawnEggItemIdFix
extends DataFix {
    private static final Short2ObjectMap<String> DAMAGE_2_ID = (Short2ObjectMap)DataFixUtils.make((Object)new Short2ObjectOpenHashMap(), map -> {
        map.put((short)0, (Object)"minecraft:polar_bear_spawn_egg");
        map.put((short)4, (Object)"minecraft:elder_guardian_spawn_egg");
        map.put((short)50, (Object)"minecraft:creeper_spawn_egg");
        map.put((short)51, (Object)"minecraft:skeleton_spawn_egg");
        map.put((short)52, (Object)"minecraft:spider_spawn_egg");
        map.put((short)54, (Object)"minecraft:zombie_spawn_egg");
        map.put((short)55, (Object)"minecraft:slime_spawn_egg");
        map.put((short)56, (Object)"minecraft:ghast_spawn_egg");
        map.put((short)57, (Object)"minecraft:zombified_piglin_spawn_egg");
        map.put((short)58, (Object)"minecraft:enderman_spawn_egg");
        map.put((short)59, (Object)"minecraft:cave_spider_spawn_egg");
        map.put((short)60, (Object)"minecraft:silverfish_spawn_egg");
        map.put((short)61, (Object)"minecraft:blaze_spawn_egg");
        map.put((short)62, (Object)"minecraft:magma_cube_spawn_egg");
        map.put((short)65, (Object)"minecraft:bat_spawn_egg");
        map.put((short)66, (Object)"minecraft:witch_spawn_egg");
        map.put((short)67, (Object)"minecraft:endermite_spawn_egg");
        map.put((short)68, (Object)"minecraft:guardian_spawn_egg");
        map.put((short)90, (Object)"minecraft:pig_spawn_egg");
        map.put((short)91, (Object)"minecraft:sheep_spawn_egg");
        map.put((short)92, (Object)"minecraft:cow_spawn_egg");
        map.put((short)93, (Object)"minecraft:chicken_spawn_egg");
        map.put((short)94, (Object)"minecraft:squid_spawn_egg");
        map.put((short)95, (Object)"minecraft:wolf_spawn_egg");
        map.put((short)96, (Object)"minecraft:mooshroom_spawn_egg");
        map.put((short)98, (Object)"minecraft:ocelot_spawn_egg");
        map.put((short)100, (Object)"minecraft:horse_spawn_egg");
        map.put((short)101, (Object)"minecraft:rabbit_spawn_egg");
        map.put((short)120, (Object)"minecraft:villager_spawn_egg");
        map.defaultReturnValue((Object)"minecraft:air");
    });

    public SpawnEggItemIdFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(TypeReferences.LEGACY_ITEM_STACK);
        OpticFinder itemIdFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)TypeReferences.ITEM_NAME.typeName(), IdentifierNormalizingSchema.getIdentifierType()));
        return this.fixTypeEverywhereTyped("SpawnEggItemIdFix", type, itemStackTyped -> {
            Optional itemId = itemStackTyped.getOptional(itemIdFinder);
            if (itemId.isPresent() && ((String)((Pair)itemId.get()).getSecond()).equals("minecraft:spawn_egg")) {
                Dynamic stack = (Dynamic)itemStackTyped.get(DSL.remainderFinder());
                short damage = stack.get("Damage").asShort((short)0);
                String newId = (String)DAMAGE_2_ID.get(damage);
                itemStackTyped = itemStackTyped.set(itemIdFinder, (Object)Pair.of((Object)TypeReferences.ITEM_NAME.typeName(), (Object)newId));
                return itemStackTyped.set(DSL.remainderFinder(), (Object)stack.remove("Damage"));
            }
            return itemStackTyped;
        });
    }
}

