/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.hmapi.network;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.stream.Collectors;
import net.azureaaron.hmapi.data.error.ErrorReason;
import net.azureaaron.hmapi.events.HypixelPacketEvents;
import net.azureaaron.hmapi.network.HypixelNetworking;
import net.azureaaron.hmapi.network.packet.c2s.HypixelC2SPacket;
import net.azureaaron.hmapi.network.packet.c2s.RegisterC2SPacket;
import net.azureaaron.hmapi.network.packet.s2c.ErrorS2CPacket;
import net.azureaaron.hmapi.network.packet.s2c.HelloS2CPacket;
import net.azureaaron.hmapi.network.packet.s2c.HypixelS2CPacket;
import net.azureaaron.hmapi.network.packet.v1.s2c.LocationUpdateS2CPacket;
import net.azureaaron.hmapi.network.packet.v1.s2c.PlayerInfoS2CPacket;
import net.azureaaron.hmapi.network.packet.v2.s2c.PartyInfoS2CPacket;
import net.azureaaron.hmapi.utils.PacketSendResult;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public class HypixelNetworkingImpl {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_310 CLIENT = class_310.method_1551();
    private static final long COOLDOWN = 1000L;
    private static final Object2LongMap<class_8710.class_9154<?>> COOLDOWNS = Object2LongMaps.synchronize((Object2LongMap)new Object2LongOpenHashMap());

    static <T extends HypixelC2SPacket> PacketSendResult sendPacket(T payload, boolean bypassCooldown) {
        if (System.currentTimeMillis() + 1000L > COOLDOWNS.computeIfAbsent((Object)payload.method_56479(), _id -> 0L) || bypassCooldown) {
            Objects.requireNonNull(CLIENT.method_1562(), "Cannot send packet while not in game!").method_52787((class_2596)new class_2817(payload));
            COOLDOWNS.put((Object)payload.method_56479(), System.currentTimeMillis());
            return PacketSendResult.success();
        }
        return PacketSendResult.onCooldown(COOLDOWNS.getLong((Object)payload.method_56479()) - System.currentTimeMillis());
    }

    private static void sendInitialEventRegistrations() {
        if (!HypixelNetworking.REGISTERED_EVENTS.isEmpty()) {
            Object2IntMap packetsToRegisterFor = (Object2IntMap)HypixelNetworking.REGISTERED_EVENTS.object2IntEntrySet().stream().collect(Collectors.toMap(e -> ((class_8710.class_9154)e.getKey()).comp_2242(), Object2IntMap.Entry::getIntValue, (a, b) -> a > b ? a : b, Object2IntOpenHashMap::new));
            HypixelNetworkingImpl.sendPacket(new RegisterC2SPacket(1, (Object2IntMap<class_2960>)packetsToRegisterFor), true);
        }
    }

    public static <T extends HypixelS2CPacket> void handlePayload(T payload) {
        CLIENT.execute(() -> {
            HypixelS2CPacket selector4$temp = payload;
            int index$5 = 0;
            block16: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PartyInfoS2CPacket.class, PlayerInfoS2CPacket.class, HelloS2CPacket.class, LocationUpdateS2CPacket.class, ErrorS2CPacket.class, ErrorS2CPacket.class, ErrorS2CPacket.class, ErrorS2CPacket.class, HypixelS2CPacket.class}, (Object)selector4$temp, index$5)) {
                    case 0: {
                        PartyInfoS2CPacket packet = (PartyInfoS2CPacket)selector4$temp;
                        ((HypixelPacketEvents.PacketCallback)HypixelPacketEvents.PARTY_INFO.invoker()).onPacket(packet);
                        return;
                    }
                    case 1: {
                        PlayerInfoS2CPacket packet = (PlayerInfoS2CPacket)selector4$temp;
                        ((HypixelPacketEvents.PacketCallback)HypixelPacketEvents.PLAYER_INFO.invoker()).onPacket(packet);
                        return;
                    }
                    case 2: {
                        HelloS2CPacket packet = (HelloS2CPacket)selector4$temp;
                        HypixelNetworkingImpl.sendInitialEventRegistrations();
                        ((HypixelPacketEvents.PacketCallback)HypixelPacketEvents.HELLO.invoker()).onPacket(packet);
                        return;
                    }
                    case 3: {
                        LocationUpdateS2CPacket packet = (LocationUpdateS2CPacket)selector4$temp;
                        ((HypixelPacketEvents.PacketCallback)HypixelPacketEvents.LOCATION_UPDATE.invoker()).onPacket(packet);
                        return;
                    }
                    case 4: {
                        class_8710.class_9154<HypixelS2CPacket> id;
                        ErrorS2CPacket $b$0 = (ErrorS2CPacket)selector4$temp;
                        try {
                            ErrorReason patt7$temp;
                            class_8710.class_9154<HypixelS2CPacket> patt6$temp;
                            id = patt6$temp = $b$0.id();
                            ErrorReason err = patt7$temp = $b$0.reason();
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        if (id.equals(PartyInfoS2CPacket.ID)) {
                            ((HypixelPacketEvents.PacketCallback)HypixelPacketEvents.PARTY_INFO.invoker()).onPacket(payload);
                            return;
                        }
                        index$5 = 5;
                        continue block16;
                    }
                    case 5: {
                        class_8710.class_9154<HypixelS2CPacket> id;
                        ErrorS2CPacket $b$1 = (ErrorS2CPacket)selector4$temp;
                        {
                            ErrorReason patt9$temp;
                            class_8710.class_9154<HypixelS2CPacket> patt8$temp;
                            id = patt8$temp = $b$1.id();
                            ErrorReason err = patt9$temp = $b$1.reason();
                        }
                        if (id.equals(PlayerInfoS2CPacket.ID)) {
                            ((HypixelPacketEvents.PacketCallback)HypixelPacketEvents.PLAYER_INFO.invoker()).onPacket(payload);
                            return;
                        }
                        index$5 = 6;
                        continue block16;
                    }
                    case 6: {
                        class_8710.class_9154<HypixelS2CPacket> id;
                        ErrorS2CPacket $b$2 = (ErrorS2CPacket)selector4$temp;
                        {
                            ErrorReason patt11$temp;
                            class_8710.class_9154<HypixelS2CPacket> patt10$temp;
                            id = patt10$temp = $b$2.id();
                            ErrorReason err = patt11$temp = $b$2.reason();
                        }
                        if (id.equals(HelloS2CPacket.ID)) {
                            ((HypixelPacketEvents.PacketCallback)HypixelPacketEvents.HELLO.invoker()).onPacket(payload);
                            return;
                        }
                        index$5 = 7;
                        continue block16;
                    }
                    case 7: {
                        class_8710.class_9154<HypixelS2CPacket> id;
                        ErrorS2CPacket $b$3 = (ErrorS2CPacket)selector4$temp;
                        {
                            ErrorReason patt13$temp;
                            class_8710.class_9154<HypixelS2CPacket> patt12$temp;
                            id = patt12$temp = $b$3.id();
                            ErrorReason err = patt13$temp = $b$3.reason();
                        }
                        if (id.equals(LocationUpdateS2CPacket.ID)) {
                            ((HypixelPacketEvents.PacketCallback)HypixelPacketEvents.LOCATION_UPDATE.invoker()).onPacket(payload);
                            return;
                        }
                        index$5 = 8;
                        continue block16;
                    }
                    case 8: {
                        HypixelS2CPacket packet = selector4$temp;
                        if (packet == HypixelS2CPacket.NOP) {
                            LOGGER.warn("[HM API] Recevied an unknown or unexpected packet!");
                            return;
                        }
                        index$5 = 9;
                        continue block16;
                    }
                }
                break;
            }
        });
    }
}

