/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.networth.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.azureaaron.networth.utils.CodecUtils;

public record SkyblockItemData(String id, Optional<String> category, Optional<List<List<GearUpgrade>>> upgradeCosts, Optional<List<GemstoneSlot>> gemstoneSlots, Optional<PrestigeItem> prestige) {
    private static final Codec<SkyblockItemData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(SkyblockItemData::id), (App)Codec.STRING.optionalFieldOf("category").forGetter(SkyblockItemData::category), (App)GearUpgrade.CODEC.listOf().listOf().optionalFieldOf("upgrade_costs").forGetter(SkyblockItemData::upgradeCosts), (App)GemstoneSlot.CODEC.listOf().optionalFieldOf("gemstone_slots").forGetter(SkyblockItemData::gemstoneSlots), (App)PrestigeItem.CODEC.optionalFieldOf("prestige").forGetter(SkyblockItemData::prestige)).apply((Applicative)instance, SkyblockItemData::new));
    private static final Codec<List<SkyblockItemData>> LIST_CODEC = CODEC.listOf();
    public static final Codec<Object2ObjectMap<String, SkyblockItemData>> MAP_CODEC = LIST_CODEC.xmap(SkyblockItemData::list2Map, map -> new ObjectArrayList(map.values()));

    private static Object2ObjectMap<String, SkyblockItemData> list2Map(List<SkyblockItemData> items) {
        return (Object2ObjectMap)items.stream().collect(Collectors.toMap(SkyblockItemData::id, Function.identity(), (a, b) -> a, Object2ObjectOpenHashMap::new));
    }

    public record GearUpgrade(Optional<String> itemId, Optional<String> essenceType, OptionalInt amount) {
        private static final Codec<GearUpgrade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("item_id").forGetter(GearUpgrade::itemId), (App)Codec.STRING.optionalFieldOf("essence_type").forGetter(GearUpgrade::essenceType), (App)CodecUtils.optionalInt((MapCodec<Optional<Integer>>)Codec.INT.optionalFieldOf("amount")).forGetter(GearUpgrade::amount)).apply((Applicative)instance, GearUpgrade::new));
    }

    public record GemstoneSlot(String type, Optional<List<GemstoneSlotCost>> costs) {
        private static final Codec<GemstoneSlot> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("slot_type").forGetter(GemstoneSlot::type), (App)GemstoneSlotCost.CODEC.listOf().optionalFieldOf("costs").forGetter(GemstoneSlot::costs)).apply((Applicative)instance, GemstoneSlot::new));

        public record GemstoneSlotCost(String type, Optional<String> itemId, OptionalInt amount, OptionalInt coins) {
            private static final Codec<GemstoneSlotCost> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(GemstoneSlotCost::type), (App)Codec.STRING.optionalFieldOf("item_id").forGetter(GemstoneSlotCost::itemId), (App)CodecUtils.optionalInt((MapCodec<Optional<Integer>>)Codec.INT.optionalFieldOf("amount")).forGetter(GemstoneSlotCost::amount), (App)CodecUtils.optionalInt((MapCodec<Optional<Integer>>)Codec.INT.optionalFieldOf("coins")).forGetter(GemstoneSlotCost::coins)).apply((Applicative)instance, GemstoneSlotCost::new));
        }
    }

    public record PrestigeItem(String itemId, List<GearUpgrade> costs) {
        private static final Codec<PrestigeItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("item_id").forGetter(PrestigeItem::itemId), (App)GearUpgrade.CODEC.listOf().fieldOf("costs").forGetter(PrestigeItem::costs)).apply((Applicative)instance, PrestigeItem::new));
    }
}

