/*
 * Decompiled with CFR 0.152.
 */
package dev.cbyrne.betterinject.injector;

import dev.cbyrne.betterinject.annotations.Arg;
import dev.cbyrne.betterinject.annotations.Local;
import dev.cbyrne.betterinject.helpers.CallbackInfoHelper;
import dev.cbyrne.betterinject.injector.strategy.ArgumentHandlingStrategy;
import dev.cbyrne.betterinject.utils.CallbackInfoUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InjectionError;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;

public class InjectInjector
extends Injector {
    private final boolean isCancellable;
    private final boolean print;
    private CallbackInfoHelper callbackInfoHelper = null;
    private final ArgumentHandlingStrategy argumentStrategy;

    public InjectInjector(InjectionInfo info, boolean isCancellable, boolean print) {
        super(info, "@Inject");
        this.isCancellable = isCancellable;
        this.print = print;
        this.argumentStrategy = ArgumentHandlingStrategy.fromMethod(this.methodNode, this.methodArgs);
    }

    protected void inject(Target target, InjectionNodes.InjectionNode node) {
        int opcode = node.getCurrentTarget().getOpcode();
        this.callbackInfoHelper = new CallbackInfoHelper(this.isCallbackInfoNeeded(), node.getCurrentTarget() instanceof InsnNode && opcode >= 172 && opcode < 177);
        if (this.argumentStrategy == ArgumentHandlingStrategy.STRICT) {
            this.checkArgumentsStrict(target);
        }
        this.checkTargetModifiers(target, true);
        this.injectInvokeCallback(target, node);
        if (this.print) {
            Bytecode.printMethod((MethodNode)target.method);
        }
    }

    private void checkArgumentsStrict(Target target) {
        if (target.arguments.length == 0) {
            return;
        }
        if (target.arguments.length > this.methodArgs.length) {
            this.strictModeArgumentCheckError(target);
        }
        for (int i = 0; i < target.arguments.length; ++i) {
            Type targetArgument = target.arguments[i];
            Type handlerArgument = this.methodArgs[i];
            if (targetArgument.equals((Object)handlerArgument)) continue;
            this.strictModeArgumentCheckError(target);
        }
    }

    private void strictModeArgumentCheckError(Target target) {
        String message = "Arguments of handler " + this.methodNode.name + " do not match target " + target.method.name;
        Injector.logger.error("Injection failure, ArgumentHandlingStrategy.STRICT mode has been enabled due to none of the handler's arguments being annotated with @Arg.", new Object[]{message});
        throw new InjectionError(message);
    }

    private void injectInvokeCallback(Target target, InjectionNodes.InjectionNode node) {
        InsnList instructions = new InsnList();
        this.callbackInfoHelper.generateCallbackInfo(instructions, target, this.isCancellable);
        this.pushDesiredArguments(instructions, target, node);
        this.invokeHandler(instructions);
        if (this.isCancellable) {
            this.callbackInfoHelper.wrapInCancellationCheck(instructions, target);
        }
        target.insns.insertBefore(node.getCurrentTarget(), instructions);
    }

    private void pushDesiredArguments(InsnList instructions, Target target, InjectionNodes.InjectionNode node) {
        if (!this.isStatic) {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        if (this.methodArgs.length == 0) {
            return;
        }
        for (int i = 0; i < this.methodArgs.length; ++i) {
            boolean isArgumentNode;
            Type argumentType = this.methodArgs[i];
            if (CallbackInfoUtils.typeIsCallbackInfo(argumentType)) {
                this.callbackInfoHelper.pushCallbackInfoIfRequired(instructions);
                continue;
            }
            AnnotationNode argNode = Annotations.getVisibleParameter((MethodNode)this.methodNode, Arg.class, (int)i);
            AnnotationNode localNode = Annotations.getVisibleParameter((MethodNode)this.methodNode, Local.class, (int)i);
            AnnotationNode annotationNode = argNode != null ? argNode : localNode;
            boolean bl = isArgumentNode = argNode != null;
            if (annotationNode != null) {
                this.pushLocalFromAnnotation(instructions, target, node, annotationNode, argumentType, isArgumentNode);
                continue;
            }
            if (this.argumentStrategy == ArgumentHandlingStrategy.STRICT) {
                instructions.add((AbstractInsnNode)new VarInsnNode(argumentType.getOpcode(21), target.getArgIndices()[i]));
                continue;
            }
            throw new IllegalStateException("Not implemented");
        }
    }

    private void pushLocalFromAnnotation(InsnList instructions, Target target, InjectionNodes.InjectionNode injectionNode, AnnotationNode annotationNode, Type desiredType, boolean argumentsOnly) {
        LocalVariableDiscriminator discriminator = LocalVariableDiscriminator.parse((AnnotationNode)annotationNode);
        LocalVariableDiscriminator.Context context = new LocalVariableDiscriminator.Context(this.info, desiredType, argumentsOnly, target, injectionNode.getCurrentTarget());
        int local = discriminator.findLocal(context);
        instructions.add((AbstractInsnNode)new VarInsnNode(desiredType.getOpcode(21), local));
    }

    private boolean isCallbackInfoNeeded() {
        for (Type argumentType : this.methodArgs) {
            if (!CallbackInfoUtils.typeIsCallbackInfo(argumentType)) continue;
            return true;
        }
        return false;
    }
}

